package com.xdja.pki.gmssl.sdf.yunhsm.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;

import java.io.*;

/**
 * @ClassName GMSSLIniFileUtils
 * @Description TODO
 * @Date 2020/5/25 11:12
 * @Author FengZhen
 */
public class GMSSLIniFileUtils {

    public static boolean createProfile(String filePath, String ip, int port, String loginPassword, String clientKeyStorePath, String trustKeyStorePath, String clientKeyStorePass, String trustKeyStorePass) throws Exception {
        StringBuilder sb = new StringBuilder();
        String lineFeed = "\n";
        sb.append("#SWXA密码设备接口配置文件").append(lineFeed);
        //确定设备  不予修改
        sb.append("[Device]").append(lineFeed);
        sb.append("device=CMD").append(lineFeed);
        //日志等级  GMSSL控制 不对外暴露
        sb.append("[ErrorLog]").append(lineFeed);
        sb.append("level=3").append(lineFeed);
        sb.append("logfile=swsds.log").append(lineFeed);
        sb.append("maxsize=100").append(lineFeed);
        sb.append("count=3").append(lineFeed);
        //密码机服务配置
        sb.append("[HSM1]").append(lineFeed);
        sb.append("ip=").append(ip).append(lineFeed);
        sb.append("port=").append(port).append(lineFeed);
        sb.append("passwd=").append(loginPassword).append(lineFeed);
        // 超时时间配置
        sb.append("[Timeout]").append(lineFeed);
        sb.append("connect=20").append(lineFeed);
        sb.append("service=20").append(lineFeed);
        // 连接池大小
        sb.append("[ConnectionPool]").append(lineFeed);
        sb.append("poolsize=50").append(lineFeed);
        //SSL配置
//        sb.append("[SSL]").append(lineFeed);
//        sb.append("ssl=1").append(lineFeed);
//        sb.append("ssllog=0").append(lineFeed);
//        sb.append("protocol=TLSv1.2").append(lineFeed);
//        sb.append("keystore=").append(clientKeyStorePath).append(lineFeed);
//        sb.append("keystoretype=JKS").append(lineFeed);
//        sb.append("trustkeystore=").append(trustKeyStorePath).append(lineFeed);
//        sb.append("trustkeystoretype=JKS").append(lineFeed);
//        sb.append("includeciphersuitefilter=*_RSA_*_SHA256$").append(lineFeed);
//        sb.append("excludeciphersuitefilter=*_256_*").append(lineFeed);
//        sb.append("trustkeystorepassword=").append(trustKeyStorePass).append(lineFeed);
//        sb.append("keystorepassword=").append(clientKeyStorePass).append(lineFeed);
        GMSSLFileUtils.writeFile(filePath, "swsds.ini", sb.toString().getBytes());
        return true;
    }

    /**
     * 构建东进密码机配置文件
     *
     * @param filePath 目录
     * @param ip       ip
     * @param port     端口
     */
    public static void createDongJinHsmIni(String filePath, String ip, int port) throws Exception {
        StringBuilder sb = new StringBuilder();
        String lineFeed = "\n";
        sb.append("########################################################################\n" +
                "########################################################################\n" +
                "## DJHsmAPI Version 2.2.0c\n" +
                "##\n" +
                "## MAX_SOCKET_PER_DEVICE\t64  每台加密机最多配的Socket连接\n" +
                "## MAX_DEVICE_GROUP\t\t\t4      最多多少个处理模块组\n" +
                "## MAX_DEVICE_PER_GROUP\t\t8      每个处理模块组最大加密机数\n" +
                "##\n" +
                "## HsmLogPath\t\t\t日志保存路径\n" +
                "## HsmLogLevel\t\t\t日志级别\n" +
                "##\t\t\t\t\t\t\t|--\t1-Error 错误日志\n" +
                "## \t\t\t\t\t\t\t|--\t2-Info  打印连接等状态相关信息\n" +
                "## \t\t\t\t\t\t\t|--\t4-Debug 调试日志-可打印通信的数据，影响性能\n" +
                "##\n" +
                "## EncryptorDispatchMode 分发模式\n" +
                "##              \t\t\t|-- 0-平均分发(并不是完全平均，由加密机处理指令速率、网络传输速率有关)\n" +
                "##              \t\t\t|-- 1-按会话分发给session绑定设备\n" +
                "##              \t\t\t|-- 2-主备模式\n" +
                "##\n" +
                "## TimeOut \t\t\t\t命令超时时间(ms)，default 5000\n" +
                "## BlockMode            数据收发模式\n" +
                "##              \t\t\t|-- 0-非阻塞接收，单线程测试时延长\n" +
                "##              \t\t\t|-- 1-阻塞接收，时延较短\n" +
                "## EncryptorGroupNum \t共有几个处理模块组\n" +
                "##\n" +
                "## EncryptorNum      \t当前模块组包含几台加密机\n" +
                "##\n" +
                "## EncryptorName\t\t\n" +
                "## SrvIPAddr\t\t\t加密机IP地址\n" +
                "## SrvPort\t\t\t\t加密机IP端口\n" +
                "## TcpConnNum\t\t\t加密机TCP连接数\n" +
                "## MsgHeadLen\t\t\t加密机消息头长\n" +
                "## MsgTailLen\t\t\t加密机消息尾长\n" +
                "## ASCIIorEBCDIC\t\t加密机编码类型\n" +
                "##\t\t\t\t\t\t\t|--\t0-ASCII编码\n" +
                "## \t\t\t\t\t\t\t|--\t1-EBCDIC编码\n" +
                "## \n" +
                "##\t\t注：EncryptorGroup_n表示第n组加密机，EncryptorGroup_n_m表示第n组加密机的第m台\n" +
                "##\n" +
                "########################################################################\n" +
                "########################################################################").append(lineFeed);
        //确定设备  不予修改
        sb.append("[HsmLog]").append(lineFeed);
        sb.append("HsmLogPath \t= ./Log").append(lineFeed);
        //日志等级 ERROR不对外暴露
        sb.append("HsmLogLevel = 1").append(lineFeed);
        sb.append("[EncryptorGroupCfg]\n" +
                "EncryptorDispatchMode \t= 0  \n" +
                "EncryptorKeySync\t\t= 0\t\n" +
                "EncryptorKeySyncIndex\t= 0 \n" +
                "EncryptorGroupNum \t\t= 1 \n" +
                "TimeOut \t\t\t\t= 5000\n" +
                "TimeDelay \t\t\t\t= 1\n" +
                "BlockMode\t\t\t\t= 0\n" +
                "\n" +
                "[EncryptorGroup_1]\n" +
                "EncryptorNum \t\t\t= 1\n" +
                "\n" +
                "[EncryptorGroup_1_1]\n" +
                "EncryptorName \t\t\t= ").append(lineFeed);

        sb.append("SrvIPAddr \t\t\t\t= ").append(ip).append(lineFeed);
        sb.append("SrvPort \t\t\t\t=").append(port).append(lineFeed);
        sb.append("TcpConnNum \t\t\t\t= 32\n" +
                "MsgHeadLen \t\t\t\t= 4\n" +
                "MsgTailLen \t\t\t\t= 0\n" +
                "ASCIIorEBCDIC \t\t\t= 0\n").append(lineFeed);
        GMSSLFileUtils.writeFile(filePath, "DJHsmAPI.ini", sb.toString().getBytes());

    }


    public static boolean setProfileValue(String writePath, String section, String key, String value) throws IOException {
        StringBuilder fileContent;
        String allLine;
        String strLine;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(writePath + File.separator + "swsds.ini"));
        fileContent = new StringBuilder();
        boolean isChange = false;
        try {
            while ((allLine = bufferedReader.readLine()) != null) {
                fileContent.append(allLine + "\n");
                allLine = allLine.trim();
                if (!allLine.startsWith("[")) {
                    continue;
                }
                if (allLine.equalsIgnoreCase("[" + section + "]")) {
                    while ((strLine = bufferedReader.readLine()) != null) {
                        if (strLine.startsWith("[")) {
                            fileContent.append(strLine + "\n");
                            break;
                        }
                        if (strLine.trim().startsWith(key)) {
                            String changeText = strLine.substring(0, strLine.indexOf('=') + 1);
                            changeText = changeText + value;
                            fileContent.append(changeText + "\n");
                            isChange = true;
                        }
                    }
                }
            }
        } catch (IOException e) {
            throw new IOException(e);
        } finally {
            bufferedReader.close();
        }
        System.out.println(fileContent);
        if (isChange) {
            GMSSLX509Utils.writeFile(writePath + File.separator, "swsds.ini", fileContent.toString().getBytes());
            return true;
        }
        return false;
    }

    public static String getProfileValue(String filePath, String item, String key) {
        String str = null;
        item = "[" + item + "]";
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
            boolean findItem = false;
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.trim().equals("") && line.charAt(0) != '#') {
                    String tmpLine = line.toLowerCase();
                    if (tmpLine.contains(item.toLowerCase())) {
                        findItem = true;
                    } else {
                        if (findItem && tmpLine.contains(key.toLowerCase())) {
                            str = line.substring(line.indexOf("=") + 1);
                            str = str.trim();
                            break;
                        }
                        if (findItem && tmpLine.contains("[")) {
                            break;
                        }
                    }
                }
            }
            br.close();
            return str;
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 获取ini配置信息
     *
     * @param filePath 文件路径
     * @param key      索引
     * @return 索引对应的值
     */
    public static String getProfileValue(String filePath, String key) {
        String str = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
            boolean findItem = false;
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.trim().equals("") && line.charAt(0) != '#') {
                    String tmpLine = line.toLowerCase();
                    if (tmpLine.contains(key.toLowerCase())) {
                        str = line.substring(line.indexOf("=") + 1);
                        str = str.trim();
                        break;
                    }
                    if (tmpLine.contains("[")) {
                        break;
                    }
                }
            }
            br.close();
            return str;
        } catch (Exception e) {
            return null;
        }
    }
}
