package com.xdja.pki.gmssl.x509.utils.bean;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;

/**
 * @ClassName GMSSLCryptoType
 * @Description TODO
 * @Date 2020/1/14 11:24
 * @Author FengZhen
 */
public enum GMSSLCryptoType {
    BC(null),
    MINI_PCI_E(null),
    PCI_E(SdfCryptoType.PCIE),
    XDJA_HSM(SdfCryptoType.YUNHSM),
    SANC_HSM(null),
    DONGJIN_HSM(null);

    private SdfCryptoType sdfCryptoType;

    GMSSLCryptoType(SdfCryptoType sdfCryptoType) {
        this.sdfCryptoType = sdfCryptoType;
    }

    public SdfCryptoType getSdfCryptoType() {
        return sdfCryptoType;
    }

    public boolean checkSdfCryptoTypeSupport() {
        return this.sdfCryptoType != null;
    }
}
