/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.init;

import com.xdja.pki.gmssl.core.utils.GMSSLECUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLRSAUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreBean;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLHsmKeyStoreUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(GMSSLHsmKeyStoreUtils.class);

    public static Map<String, GMSSLHsmKeyStoreBean> analysisKeyStore(KeyStore keyStore) {
        if (null == keyStore) {
            return null;
        }
        try {
            HashMap<String, GMSSLHsmKeyStoreBean> map = new HashMap<String, GMSSLHsmKeyStoreBean>();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                GMSSLHsmKeyStoreBean bean = new GMSSLHsmKeyStoreBean();
                Key key = keyStore.getKey(alias, "xdja1234".toCharArray());
                if (key instanceof SecretKey) {
                    bean.setSecretKey((SecretKey)key);
                } else {
                    PrivateKey privateKey = (PrivateKey)key;
                    String algorithm = privateKey.getAlgorithm();
                    bean.setPrivateKey(privateKey);
                    if ("EC".equalsIgnoreCase(algorithm)) {
                        bean.setPublicKey(GMSSLECUtils.convertPublicKey((PrivateKey)privateKey));
                    } else if ("RSA".equalsIgnoreCase(algorithm)) {
                        RSAPrivateCrtKey rsaPrivateKey = (RSAPrivateCrtKey)privateKey;
                        RSAPublicKey rsaPublicKey = GMSSLRSAUtils.convertRSAPublicKey((byte[])rsaPrivateKey.getModulus().toByteArray(), (byte[])rsaPrivateKey.getPublicExponent().toByteArray());
                        bean.setPublicKey(rsaPublicKey);
                    }
                }
                bean.setPwd("xdja1234");
                bean.setIndex(alias);
                map.put(alias, bean);
            }
            return map;
        }
        catch (Exception e) {
            LOGGER.error("hsmKeyStore\u89e3\u6790\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static GMSSLHsmKeyStoreBean getSymKey(Integer index) throws Exception {
        String key = MessageFormat.format("sym_{0}", index);
        return GMSSLHsmKeyStoreUtils.getHsmKeyStoreBean(key);
    }

    public static GMSSLHsmKeyStoreBean getAsymKey(Integer index, boolean isEnc) throws Exception {
        String key = isEnc ? MessageFormat.format("asym_enc_{0}", index) : MessageFormat.format("asym_sign_{0}", index);
        return GMSSLHsmKeyStoreUtils.getHsmKeyStoreBean(key);
    }

    public static GMSSLHsmKeyStoreBean getHsmKeyStoreBean(String index) throws Exception {
        GMSSLHsmKeyStoreBean bean = GMSSLPkiCryptoInit.getHsmKeyStoreMap().get(index);
        if (null == bean) {
            throw new Exception("\u7d22\u5f15\u5bf9\u5e94\u5bc6\u94a5\u4e0d\u5b58\u5728");
        }
        return bean;
    }
}

