/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.init;

import com.xdja.SafeKey.utils.pool.MiniPcieConnectionPool;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreBean;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.sdf.pcie.pool.PcieConnectionProviderImpl;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLHsmUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import java.io.File;
import java.security.KeyStore;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLPkiCryptoInit {
    private static String JSON_PATH = File.separator + "etc" + File.separator + "xdsdfjni.json";
    private static Logger logger = LoggerFactory.getLogger(GMSSLPkiCryptoInit.class);
    private static final GMSSLPkiCryptoInit INSTANCE = new GMSSLPkiCryptoInit();
    private GMSSLCryptoType cryptoType = GMSSLCryptoType.BC;
    private KeyStore hsmKeyStore;
    private Map<String, GMSSLHsmKeyStoreBean> hsmKeyStoreMap;

    private GMSSLPkiCryptoInit() {
    }

    public static GMSSLCryptoType getCryptoType() {
        return GMSSLPkiCryptoInit.INSTANCE.cryptoType;
    }

    public static GMSSLCryptoType getSdfCryptoType() throws Exception {
        if (!GMSSLPkiCryptoInit.INSTANCE.cryptoType.checkSdfCryptoTypeSupport()) {
            throw new Exception("un support this crypto" + (Object)((Object)GMSSLPkiCryptoInit.INSTANCE.cryptoType));
        }
        return GMSSLPkiCryptoInit.INSTANCE.cryptoType;
    }

    public static void getBCInstance() {
        GMSSLPkiCryptoInit.INSTANCE.cryptoType = GMSSLCryptoType.BC;
    }

    public static void getHsmInstance() {
        String jsonPath = GMSSLHsmUtils.getConfPath(false) + JSON_PATH;
        logger.info("\u8bfb\u53d6json\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a" + jsonPath);
        HsmUtils.resetHsmconfigPath((String)jsonPath);
        HsmUtils.setHsmType();
        GMSSLPkiCryptoInit.INSTANCE.cryptoType = GMSSLCryptoType.XDJA_HSM;
    }

    public static void getXdjaYunHsmInstance() {
        GMSSLPkiCryptoInit.INSTANCE.cryptoType = GMSSLCryptoType.XDJA_HSM;
    }

    public static void getPcieInstance() {
        PcieConnectionProviderImpl.getInstance();
        GMSSLPkiCryptoInit.INSTANCE.cryptoType = GMSSLCryptoType.PCI_E;
    }

    public static void getDJHsmInstance() {
        GMSSLPkiCryptoInit.INSTANCE.cryptoType = GMSSLCryptoType.DONGJIN_HSM;
    }

    public static void getMiniPcieInstance() {
        MiniPcieConnectionPool.getInstance();
        GMSSLPkiCryptoInit.INSTANCE.cryptoType = GMSSLCryptoType.MINI_PCI_E;
    }

    public static void getSancHsmInstance() throws Exception {
        GMSSLSancConnectionUtils.init();
        GMSSLPkiCryptoInit.INSTANCE.cryptoType = GMSSLCryptoType.SANC_HSM;
    }

    public static void getSancHsmInstance(String configPath) throws Exception {
        GMSSLSancConnectionUtils.init(configPath);
        GMSSLPkiCryptoInit.INSTANCE.cryptoType = GMSSLCryptoType.SANC_HSM;
    }

    public static void setHsmKeyStore(KeyStore keyStore) {
        GMSSLPkiCryptoInit.INSTANCE.hsmKeyStore = keyStore;
        GMSSLPkiCryptoInit.INSTANCE.hsmKeyStoreMap = GMSSLHsmKeyStoreUtils.analysisKeyStore(keyStore);
    }

    public static KeyStore getHsmKeyStore() {
        return GMSSLPkiCryptoInit.INSTANCE.hsmKeyStore;
    }

    public static Map<String, GMSSLHsmKeyStoreBean> getHsmKeyStoreMap() {
        return GMSSLPkiCryptoInit.INSTANCE.hsmKeyStoreMap;
    }

    public static boolean isHsmServer() {
        return null != GMSSLPkiCryptoInit.INSTANCE.hsmKeyStoreMap && !GMSSLPkiCryptoInit.INSTANCE.hsmKeyStoreMap.isEmpty();
    }
}

