/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.crypto_hsm.sds.CMDCrypto;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refKeyPair;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPublicKey;
import com.xdja.SafeKey.Sm2PrivateKey;
import com.xdja.SafeKey.Sm2PublicKey;
import com.xdja.SafeKey.bean.MiniPcieIndexEnum;
import com.xdja.SafeKey.utils.MiniPcieXKFUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLECUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreBean;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConverUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancKeyTypeEnum;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDK;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDKUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLECKeyUtils {
    private static Logger logger;
    public static final String SM2p256;
    public static final String NISTp256;
    public static final String NISTp384;
    public static final String NISTp521;

    public static KeyPair generateECKeyPair(String stdName) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            return GMSSLECUtils.generateKeyPair((String)stdName);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                return GMSSLECKeyUtils.generateECKeyPairBySdf(SdfCryptoType.PCIE, stdName);
            }
            case XDJA_HSM: {
                return GMSSLECKeyUtils.generateECKeyPairBySdf(SdfCryptoType.YUNHSM, stdName);
            }
            case DONGJIN_HSM: {
                return GMSSLECKeyUtils.generateECKeyPairBySdf(SdfCryptoType.DONGJIN, stdName);
            }
            case MINI_PCI_E: {
                return MiniPcieXKFUtils.generateSm2KeyPair();
            }
            case SANC_HSM: {
                return GMSSLECKeyUtils.generateECKeyPairBySancHsm(stdName);
            }
        }
        return GMSSLECUtils.generateKeyPair((String)stdName);
    }

    public static SdfPrivateKey genSdfPrivateKey(int index, String password) {
        return new SdfPrivateKey(index, password);
    }

    public static SdfPrivateKey genSdfPrivateKey(int index) {
        return new SdfPrivateKey(index);
    }

    public static boolean getPrivateKeyAccessRightFromHardware(int index, String password) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            return GMSSLECKeyUtils.getPrivateKeyAccessRightFromYunHsm(index, password);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM: {
                return YunhsmSdfSDKUtils.checkPrivateKeyAccess((int)index, (String)password);
            }
            case DONGJIN_HSM: {
                return GMSSLECKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.DONGJIN, index, password);
            }
            case PCI_E: {
                return GMSSLECKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.PCIE, index, password);
            }
            case MINI_PCI_E: {
                return MiniPcieXKFUtils.verifyPin((byte[])password.getBytes());
            }
        }
        throw new Exception("un support the method with the crypto type " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static PublicKey getPublicKeyFromHardware(int index, String stdName, boolean isEncryptKey) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            GMSSLHsmKeyStoreBean bean = GMSSLHsmKeyStoreUtils.getAsymKey(index, isEncryptKey);
            return bean.getPublicKey();
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                if (isEncryptKey) {
                    return GMSSLECKeyUtils.getEncryptPublicKeyByPcie(index, stdName);
                }
                return GMSSLECKeyUtils.getSignPublicKeyByPcie(index, stdName);
            }
            case XDJA_HSM: {
                if (isEncryptKey) {
                    return GMSSLECKeyUtils.getEncryptPublicKeyByYunhsm(index, stdName);
                }
                return GMSSLECKeyUtils.getSignPublicKeyByYunhsm(index, stdName);
            }
            case DONGJIN_HSM: {
                if (isEncryptKey) {
                    return GMSSLECKeyUtils.getEncPublicKeyByDongJinHsm(index, stdName);
                }
                return GMSSLECKeyUtils.getSignPublicKeyByDongJinHsm(index, stdName);
            }
            case MINI_PCI_E: {
                if (isEncryptKey) {
                    return MiniPcieXKFUtils.readSm2PublicKey((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)index).getEncPublicKeyIndex()).getPublicKey(stdName);
                }
                return MiniPcieXKFUtils.readSm2PublicKey((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)index).getSignPublicKeyIndex()).getPublicKey(stdName);
            }
            case SANC_HSM: {
                ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
                SM2refPublicKey sm2PublicKey = isEncryptKey ? cryptConnection.getSM2PublicKey(index, GMSSLSancKeyTypeEnum.ENCRYPT.getKeyType()) : cryptConnection.getSM2PublicKey(index, GMSSLSancKeyTypeEnum.SIGN.getKeyType());
                return GMSSLSancConverUtils.converSM2PublicKey(sm2PublicKey);
            }
        }
        throw new Exception("un support the method with the crypto type " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static boolean writeKeyPairToHardWare(int index, String password, KeyPair keyPair, boolean isEncryptKey) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case MINI_PCI_E: {
                if (isEncryptKey) {
                    boolean b = MiniPcieXKFUtils.writeSm2PublicKey((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)index).getEncPublicKeyIndex(), (String)password, (Sm2PublicKey)new Sm2PublicKey(keyPair.getPublic()));
                    if (!b) {
                        return false;
                    }
                    return MiniPcieXKFUtils.writeSm2PrivateKey((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)index).getEncPrivateIndex(), (String)password, (Sm2PrivateKey)new Sm2PrivateKey(keyPair.getPrivate()));
                }
                boolean b = MiniPcieXKFUtils.writeSm2PublicKey((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)index).getSignPublicKeyIndex(), (String)password, (Sm2PublicKey)new Sm2PublicKey(keyPair.getPublic()));
                if (!b) {
                    return false;
                }
                return MiniPcieXKFUtils.writeSm2PrivateKey((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)index).getSignPrivateIndex(), (String)password, (Sm2PrivateKey)new Sm2PrivateKey(keyPair.getPrivate()));
            }
            case PCI_E: {
                PcieSdfSDK pcieSdfSDK = new PcieSdfSDK();
                if (isEncryptKey) {
                    try {
                        pcieSdfSDK.importSM2PublicKey(keyPair.getPublic(), index, false);
                        pcieSdfSDK.importSM2PrivateKey(keyPair.getPrivate(), index, password.getBytes(), false);
                        return true;
                    }
                    catch (Exception e) {
                        logger.error("\u5bfc\u5165SM2\u52a0\u5bc6\u5bc6\u94a5\u5bf9\u5931\u8d25", (Throwable)e);
                        return false;
                    }
                }
                try {
                    pcieSdfSDK.importSM2PublicKey(keyPair.getPublic(), index, true);
                    pcieSdfSDK.importSM2PrivateKey(keyPair.getPrivate(), index, password.getBytes(), true);
                    return true;
                }
                catch (Exception e) {
                    logger.error("\u5bfc\u5165SM2\u7b7e\u540d\u5bc6\u94a5\u5bf9\u5931\u8d25", (Throwable)e);
                    return false;
                }
            }
        }
        throw new Exception("un support writeCertToHardWare  with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static KeyPair generateECKeyPairBySancHsm(String stdName) throws Exception {
        CMDCrypto cmdCrypto = new CMDCrypto();
        if (!stdName.equalsIgnoreCase(SM2p256)) {
            return null;
        }
        SM2refKeyPair sm2refKeyPair = cmdCrypto.generateSM2KeyPair(256);
        PublicKey publicKey = GMSSLX509Utils.convertSM2PublicKey((byte[])sm2refKeyPair.getPublicKey().getX(), (byte[])sm2refKeyPair.getPublicKey().getY());
        PrivateKey privateKey = GMSSLX509Utils.convertSM2PrivateKey((byte[])sm2refKeyPair.getPrivateKey().getD());
        return new KeyPair(publicKey, privateKey);
    }

    @Deprecated
    public static KeyPair generateECKeyPairByBC(String stdName) throws Exception {
        return GMSSLECUtils.generateKeyPair((String)stdName);
    }

    public static KeyPair generateECKeyPairBySdf(SdfCryptoType sdfCryptoType, String stdName) throws Exception {
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLECKeyUtils.generateECKeyPair(stdName);
        }
        SdfSDK sdfSDK = sdfCryptoType.getSdfSDK();
        sdfSDK.init();
        SdfECKey sdfECKey = new SdfECKey(sdfCryptoType, stdName);
        return sdfECKey.generateKeyPair();
    }

    public static PublicKey getSignPublicKeyByYunhsm(int index, String stdName) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer() || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.DONGJIN_HSM) {
            return GMSSLECKeyUtils.getPublicKeyFromHardware(index, stdName, false);
        }
        SdfECKey sdfECKey = new SdfECKey(SdfCryptoType.YUNHSM, stdName);
        PublicKey publicKey = sdfECKey.exportSignPublicKey(index);
        sdfECKey.release();
        return publicKey;
    }

    public static PublicKey getSignPublicKeyByDongJinHsm(int index, String stdName) throws Exception {
        SdfECKey sdfECKey = new SdfECKey(SdfCryptoType.DONGJIN, stdName);
        PublicKey publicKey = sdfECKey.exportSignPublicKey(index);
        sdfECKey.release();
        return publicKey;
    }

    public static PublicKey getEncPublicKeyByDongJinHsm(int index, String stdName) throws Exception {
        SdfECKey sdfECKey = new SdfECKey(SdfCryptoType.DONGJIN, stdName);
        PublicKey publicKey = sdfECKey.exportEncryptPublicKey(index);
        sdfECKey.release();
        return publicKey;
    }

    public static PublicKey getSignPublicKeyByPcie(int index, String stdName) throws SdfSDKException {
        SdfECKey sdfECKey = new SdfECKey(SdfCryptoType.PCIE, stdName);
        PublicKey publicKey = sdfECKey.exportSignPublicKey(index);
        sdfECKey.release();
        return publicKey;
    }

    public static PublicKey getEncryptPublicKeyByYunhsm(int index, String stdName) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer() || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.DONGJIN_HSM) {
            return GMSSLECKeyUtils.getPublicKeyFromHardware(index, stdName, true);
        }
        SdfECKey sdfECKey = new SdfECKey(SdfCryptoType.YUNHSM, stdName);
        PublicKey publicKey = sdfECKey.exportEncryptPublicKey(index);
        sdfECKey.release();
        return publicKey;
    }

    public static PublicKey getEncryptPublicKeyByPcie(int index, String stdName) throws SdfSDKException {
        SdfECKey sdfECKey = new SdfECKey(SdfCryptoType.PCIE, stdName);
        PublicKey publicKey = sdfECKey.exportEncryptPublicKey(index);
        sdfECKey.release();
        return publicKey;
    }

    public static boolean getPrivateKeyAccessRightFromYunHsm(int index, String password) {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            GMSSLHsmKeyStoreBean bean;
            try {
                bean = GMSSLHsmKeyStoreUtils.getAsymKey(index, false);
            }
            catch (Exception e) {
                try {
                    bean = GMSSLHsmKeyStoreUtils.getAsymKey(index, true);
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return bean.getPwd().equals(password);
        }
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.DONGJIN_HSM) {
            return GMSSLECKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.DONGJIN, index, password);
        }
        return YunhsmSdfSDKUtils.checkPrivateKeyAccess((int)index, (String)password);
    }

    @Deprecated
    public static boolean checkPrivateKeyAccessRightFromYunHsm(int index, String password) {
        return GMSSLECKeyUtils.getPrivateKeyAccessRightFromYunHsm(index, password);
    }

    @Deprecated
    public static boolean checkPrivateKeyAccessRightFromPCIE(int index, String password) {
        return GMSSLECKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.PCIE, index, password);
    }

    public static boolean checkPrivateKeyAccessRightFromSdf(SdfCryptoType sdfCryptoType, int index, String password) {
        try {
            if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.DONGJIN_HSM) {
                sdfCryptoType = SdfCryptoType.DONGJIN;
            }
            SdfSDK sdfSDK = sdfCryptoType.getSdfSDK();
            sdfSDK.init();
            boolean result = sdfSDK.checkPrivateKeyAccessRight(index, password.getBytes());
            sdfSDK.release();
            return result;
        }
        catch (SdfSDKException e) {
            return false;
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        logger = LoggerFactory.getLogger(GMSSLECKeyUtils.class);
        SM2p256 = GMNamedCurves.getName((ASN1ObjectIdentifier)GMObjectIdentifiers.sm2p256v1);
        NISTp256 = NISTNamedCurves.getName((ASN1ObjectIdentifier)SECObjectIdentifiers.secp256r1);
        NISTp384 = NISTNamedCurves.getName((ASN1ObjectIdentifier)SECObjectIdentifiers.secp384r1);
        NISTp521 = NISTNamedCurves.getName((ASN1ObjectIdentifier)SECObjectIdentifiers.secp521r1);
    }
}

