/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.IRSArefPublicKey;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLRSAUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreBean;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConverUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancKeyTypeEnum;
import com.xdja.pki.gmssl.operator.utils.GMSSLPKCS1Encodeing;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;

public class GMSSLRSAEncryptUtils {
    public static byte[] encrypt(PublicKey publicKey, byte[] data) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            default: 
        }
        return GMSSLRSAUtils.encryptData((PublicKey)publicKey, (byte[])data);
    }

    public static byte[] decrypt(PrivateKey privateKey, byte[] cipher) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            default: 
        }
        return GMSSLRSAUtils.decryptData((PrivateKey)privateKey, (byte[])cipher);
    }

    public static byte[] encryptWithPKCS1(PublicKey publicKey, byte[] data) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case SANC_HSM: {
                int bitLength = ((BCRSAPublicKey)publicKey).getModulus().bitLength();
                byte[] encodeData = GMSSLPKCS1Encodeing.encodeBlock(data, 0, data.length, bitLength);
                IRSArefPublicKey arefPublicKey = GMSSLSancConverUtils.converRSARefPublicKey(publicKey);
                return GMSSLSancConnectionUtils.getCryptConnection().rsaPublicKeyOperation(arefPublicKey, encodeData);
            }
        }
        return GMSSLRSAUtils.encryptDataPKCS1Padding((PublicKey)publicKey, (byte[])data);
    }

    public static byte[] decryptWithPKCS1(PrivateKey privateKey, byte[] cipher) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            SdfPrivateKey pciePrivateKey = (SdfPrivateKey)privateKey;
            GMSSLHsmKeyStoreBean bean = GMSSLHsmKeyStoreUtils.getAsymKey(pciePrivateKey.getIndex(), true);
            return GMSSLRSAUtils.decryptDataPKCS1Padding((PrivateKey)bean.getPrivateKey(), (byte[])cipher);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case SANC_HSM: {
                ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
                SdfPrivateKey sancPrivate = (SdfPrivateKey)privateKey;
                byte[] decrypt = cryptConnection.rsaPrivateKeyOperation(sancPrivate.getIndex(), GMSSLSancKeyTypeEnum.ENCRYPT.getKeyType(), cipher);
                IRSArefPublicKey rsaPublicKey = cryptConnection.getRSAPublicKey(sancPrivate.getIndex(), GMSSLSancKeyTypeEnum.ENCRYPT.getKeyType());
                return GMSSLPKCS1Encodeing.decodeBlock(decrypt, rsaPublicKey.getBits());
            }
        }
        return GMSSLRSAUtils.decryptDataPKCS1Padding((PrivateKey)privateKey, (byte[])cipher);
    }

    public static String encryptDataByBC(PublicKey publicKey, String data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] plain = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] cipher = GMSSLRSAUtils.encryptData((PublicKey)publicKey, (byte[])plain);
        return GMSSLByteArrayUtils.base64Encode((byte[])cipher);
    }

    public static String decryptDataByBC(PrivateKey privateKey, String data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] cipher = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] plain = GMSSLRSAUtils.decryptData((PrivateKey)privateKey, (byte[])cipher);
        return GMSSLByteArrayUtils.base64Encode((byte[])plain);
    }

    public static byte[] encryptDataByBC(PublicKey publicKey, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return GMSSLRSAUtils.encryptData((PublicKey)publicKey, (byte[])data);
    }

    public static byte[] decryptDataByBC(PrivateKey privateKey, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return GMSSLRSAUtils.decryptData((PrivateKey)privateKey, (byte[])data);
    }

    public static String encryptDataPKCS1ByBC(PublicKey publicKey, String data) throws InvalidCipherTextException {
        byte[] plain = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] cipher = GMSSLRSAUtils.encryptDataPKCS1Padding((PublicKey)publicKey, (byte[])plain);
        return GMSSLByteArrayUtils.base64Encode((byte[])cipher);
    }

    public static String decryptDataPKCS1ByBC(PrivateKey privateKey, String data) throws InvalidCipherTextException {
        byte[] cipher = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] plain = GMSSLRSAUtils.decryptDataPKCS1Padding((PrivateKey)privateKey, (byte[])cipher);
        return GMSSLByteArrayUtils.base64Encode((byte[])plain);
    }

    public static byte[] encryptDataPKCS1ByBC(PublicKey publicKey, byte[] data) throws InvalidCipherTextException {
        return GMSSLRSAUtils.encryptDataPKCS1Padding((PublicKey)publicKey, (byte[])data);
    }

    public static byte[] decryptDataPKCS1ByBC(PrivateKey privateKey, byte[] data) throws InvalidCipherTextException {
        return GMSSLRSAUtils.decryptDataPKCS1Padding((PrivateKey)privateKey, (byte[])data);
    }
}

