/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.SafeKey.utils.MiniPcieXKFUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfRandom;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class GMSSLRandomUtils {
    public static byte[] generateRandom(int length) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            return com.xdja.pki.gmssl.core.utils.GMSSLRandomUtils.generateRandom((int)length);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                SdfRandom pcieRandom = new SdfRandom(SdfCryptoType.PCIE);
                return pcieRandom.generateRandom(length);
            }
            case XDJA_HSM: {
                SdfRandom hsmRandom = new SdfRandom(SdfCryptoType.YUNHSM);
                return hsmRandom.generateRandom(length);
            }
            case DONGJIN_HSM: {
                SdfRandom dJRandom = new SdfRandom(SdfCryptoType.DONGJIN);
                return dJRandom.generateRandom(length);
            }
            case MINI_PCI_E: {
                return MiniPcieXKFUtils.generateRandom((int)length);
            }
            case SANC_HSM: {
                return GMSSLSancConnectionUtils.getCryptConnection().generateRandom(length);
            }
        }
        return com.xdja.pki.gmssl.core.utils.GMSSLRandomUtils.generateRandom((int)length);
    }

    public static String generateRandomByYunhsm(int len) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer() || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.DONGJIN_HSM) {
            return GMSSLRandomUtils.generateRandomBySdf(SdfCryptoType.DONGJIN, len);
        }
        return GMSSLRandomUtils.generateRandomBySdf(SdfCryptoType.YUNHSM, len);
    }

    public static String generateRandomByPcie(int len) throws Exception {
        return GMSSLRandomUtils.generateRandomBySdf(SdfCryptoType.PCIE, len);
    }

    public static String generateRandomBySdf(SdfCryptoType sdfCryptoType, int len) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer() || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return Base64.toBase64String((byte[])GMSSLRandomUtils.generateRandom(len));
        }
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.DONGJIN_HSM) {
            sdfCryptoType = SdfCryptoType.DONGJIN;
        }
        SdfRandom sdfRandom = new SdfRandom(sdfCryptoType);
        byte[] random = sdfRandom.generateRandom(len);
        return GMSSLByteArrayUtils.base64Encode((byte[])random);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

