/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSHADigest;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLSHA512DigestUtils {
    public static byte[] digest(byte[] data) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            return GMSSLSHA512DigestUtils.digestByBC(data);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case XDJA_HSM: {
                return GMSSLSHA512DigestUtils.digestBySdf(SdfCryptoType.YUNHSM, data);
            }
        }
        return GMSSLSHA512DigestUtils.digestByBC(data);
    }

    public static String digestByBC(String data) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSHA512DigestUtils.digestByBC(GMSSLByteArrayUtils.base64Decode((String)data)));
    }

    public static byte[] digestByBC(byte[] data) throws Exception {
        MessageDigest instance = MessageDigest.getInstance("SHA-512", "BC");
        return instance.digest(data);
    }

    public static String digestByYunHsm(String data) throws Exception {
        return GMSSLByteArrayUtils.base64Encode((byte[])GMSSLSHA512DigestUtils.digestByYunHsm(GMSSLByteArrayUtils.base64Decode((String)data)));
    }

    public static byte[] digestByYunHsm(byte[] data) throws Exception {
        return GMSSLSHA512DigestUtils.digestBySdf(SdfCryptoType.YUNHSM, data);
    }

    public static byte[] digestBySdf(SdfCryptoType sdfCryptoType, byte[] data) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer() || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLSHA512DigestUtils.digest(data);
        }
        SdfSHADigest sdfSHADigest = new SdfSHADigest(sdfCryptoType.getSdfSDK(), SdfAlgIdHash.SGD_SHA512);
        sdfSHADigest.update(data, 0, data.length);
        byte[] digest = new byte[sdfSHADigest.getDigestSize()];
        sdfSHADigest.doFinal(digest, 0);
        return digest;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

