/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refCipher;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPublicKey;
import com.xdja.SafeKey.utils.MiniPcieSm2EncryptUtils;
import com.xdja.pki.gmssl.asn1.crypto.ASN1SM2Cipher;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreBean;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECEngine;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConverUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancKeyTypeEnum;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLSM2EncryptUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)GMSSLSM2EncryptUtils.class.getName());

    public static byte[] encrypt(PublicKey publicKey, byte[] data) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            return GMSSLSM2EncryptUtils.encryptByBC(publicKey, data);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                return GMSSLSM2EncryptUtils.encryptBySdf(SdfCryptoType.PCIE, publicKey, data, 0, data.length);
            }
            case MINI_PCI_E: {
                return MiniPcieSm2EncryptUtils.encrypt((byte[])data, (PublicKey)publicKey, (boolean)false);
            }
            case XDJA_HSM: {
                return GMSSLSM2EncryptUtils.encryptBySdf(SdfCryptoType.YUNHSM, publicKey, data, 0, data.length);
            }
            case DONGJIN_HSM: {
                return GMSSLSM2EncryptUtils.encryptBySdf(SdfCryptoType.DONGJIN, publicKey, data, 0, data.length);
            }
            case SANC_HSM: {
                return GMSSLSM2EncryptUtils.encryptBySanc(publicKey, data);
            }
        }
        return GMSSLSM2EncryptUtils.encryptByBC(publicKey, data);
    }

    public static byte[] decrypt(PrivateKey privateKey, byte[] data) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            SdfPrivateKey pciePrivate = (SdfPrivateKey)privateKey;
            GMSSLHsmKeyStoreBean bean = GMSSLHsmKeyStoreUtils.getAsymKey(pciePrivate.getIndex(), true);
            AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPrivateKeyKeyParameters((PrivateKey)bean.getPrivateKey());
            return GMSSLSM2EncryptUtils.decryptByBC((ECKeyParameters)keyParameter, data, 0, data.length);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                SdfPrivateKey pciePrivate = (SdfPrivateKey)privateKey;
                return GMSSLSM2EncryptUtils.decryptBySdf(SdfCryptoType.PCIE, pciePrivate.getIndex(), pciePrivate.getStringPassword(), data, 0, data.length);
            }
            case MINI_PCI_E: {
                SdfPrivateKey miniPciePrivate = (SdfPrivateKey)privateKey;
                return MiniPcieSm2EncryptUtils.decrypt((byte[])data, (int)miniPciePrivate.getIndex(), (String)miniPciePrivate.getStringPassword(), (boolean)false);
            }
            case XDJA_HSM: {
                SdfPrivateKey hsmPrivate = (SdfPrivateKey)privateKey;
                return GMSSLSM2EncryptUtils.decryptBySdf(SdfCryptoType.YUNHSM, hsmPrivate.getIndex(), hsmPrivate.getStringPassword(), data, 0, data.length);
            }
            case DONGJIN_HSM: {
                SdfPrivateKey dJPrivate = (SdfPrivateKey)privateKey;
                return GMSSLSM2EncryptUtils.decryptBySdf(SdfCryptoType.DONGJIN, dJPrivate.getIndex(), dJPrivate.getStringPassword(), data, 0, data.length);
            }
            case SANC_HSM: {
                return GMSSLSM2EncryptUtils.decryptBySanc(privateKey, data);
            }
        }
        AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPrivateKeyKeyParameters((PrivateKey)privateKey);
        return GMSSLSM2EncryptUtils.decryptByBC((ECKeyParameters)keyParameter, data, 0, data.length);
    }

    public static byte[] encryptAsn1Data(PublicKey publicKey, byte[] data) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            return GMSSLSM2EncryptUtils.encryptASN1ByBC(publicKey, data);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                return GMSSLSM2EncryptUtils.encryptASN1BySdf(SdfCryptoType.PCIE, publicKey, data, 0, data.length);
            }
            case MINI_PCI_E: {
                return MiniPcieSm2EncryptUtils.encrypt((byte[])data, (PublicKey)publicKey, (boolean)true);
            }
            case XDJA_HSM: {
                return GMSSLSM2EncryptUtils.encryptASN1BySdf(SdfCryptoType.YUNHSM, publicKey, data, 0, data.length);
            }
            case DONGJIN_HSM: {
                return GMSSLSM2EncryptUtils.encryptASN1BySdf(SdfCryptoType.DONGJIN, publicKey, data, 0, data.length);
            }
            case SANC_HSM: {
                return GMSSLSM2EncryptUtils.encryptAsn1BySanc(publicKey, data);
            }
        }
        return GMSSLSM2EncryptUtils.encryptASN1ByBC(publicKey, data);
    }

    public static byte[] decryptAsn1Cipher(PrivateKey privateKey, byte[] data) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            SdfPrivateKey pciePrivate = (SdfPrivateKey)privateKey;
            GMSSLHsmKeyStoreBean bean = GMSSLHsmKeyStoreUtils.getAsymKey(pciePrivate.getIndex(), true);
            AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPrivateKeyKeyParameters((PrivateKey)bean.getPrivateKey());
            return GMSSLSM2EncryptUtils.decryptASN1ByBC((ECKeyParameters)keyParameter, data, 0, data.length);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                SdfPrivateKey pciePrivate = (SdfPrivateKey)privateKey;
                return GMSSLSM2EncryptUtils.decryptASN1BySdf(SdfCryptoType.PCIE, pciePrivate.getIndex(), pciePrivate.getStringPassword(), data, 0, data.length);
            }
            case MINI_PCI_E: {
                SdfPrivateKey miniPciePrivate = (SdfPrivateKey)privateKey;
                return MiniPcieSm2EncryptUtils.decrypt((byte[])data, (int)miniPciePrivate.getIndex(), (String)miniPciePrivate.getStringPassword(), (boolean)true);
            }
            case XDJA_HSM: {
                SdfPrivateKey hsmPrivate = (SdfPrivateKey)privateKey;
                return GMSSLSM2EncryptUtils.decryptASN1BySdf(SdfCryptoType.YUNHSM, hsmPrivate.getIndex(), hsmPrivate.getStringPassword(), data, 0, data.length);
            }
            case DONGJIN_HSM: {
                SdfPrivateKey dJPrivate = (SdfPrivateKey)privateKey;
                return GMSSLSM2EncryptUtils.decryptASN1BySdf(SdfCryptoType.DONGJIN, dJPrivate.getIndex(), dJPrivate.getStringPassword(), data, 0, data.length);
            }
            case SANC_HSM: {
                return GMSSLSM2EncryptUtils.decryptAsn1BySanc(privateKey, data);
            }
        }
        AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPrivateKeyKeyParameters((PrivateKey)privateKey);
        return GMSSLSM2EncryptUtils.decryptASN1ByBC((ECKeyParameters)keyParameter, data, 0, data.length);
    }

    private static byte[] encryptBySanc(PublicKey publicKey, byte[] data) throws Exception {
        ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
        SM2refPublicKey sm2refPublicKey = GMSSLSancConverUtils.converSM2RefPublicKey(publicKey);
        SM2refCipher sm2refCipher = cryptConnection.sm2Encrypt(sm2refPublicKey, data);
        byte[] x = sm2refCipher.getX();
        byte[] y = sm2refCipher.getY();
        byte[] c = sm2refCipher.getC();
        c = GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])c, (int)data.length);
        byte[] m = sm2refCipher.getM();
        byte[] PO = new byte[x.length + y.length + 1];
        PO[0] = 4;
        System.arraycopy(x, 0, PO, 1, x.length);
        System.arraycopy(y, 0, PO, x.length + 1, y.length);
        byte[] cipher = new byte[PO.length + c.length + m.length];
        System.arraycopy(PO, 0, cipher, 0, PO.length);
        System.arraycopy(c, 0, cipher, PO.length, c.length);
        System.arraycopy(m, 0, cipher, PO.length + c.length, m.length);
        return cipher;
    }

    private static byte[] decryptBySanc(PrivateKey privateKey, byte[] data) throws Exception {
        ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
        SdfPrivateKey sancPrivate = (SdfPrivateKey)privateKey;
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        byte[] m = new byte[32];
        byte[] c = new byte[data.length - 1 - x.length - y.length - m.length];
        System.arraycopy(data, 1, x, 0, x.length);
        System.arraycopy(data, 1 + x.length, y, 0, y.length);
        System.arraycopy(data, 1 + x.length + y.length, c, 0, c.length);
        System.arraycopy(data, 1 + x.length + y.length + c.length, m, 0, m.length);
        SM2refCipher sm2refCipher = new SM2refCipher(x, y, c, m);
        return cryptConnection.sm2Decrypt(sancPrivate.getIndex(), GMSSLSancKeyTypeEnum.ENCRYPT.getKeyType(), sm2refCipher);
    }

    private static byte[] encryptAsn1BySanc(PublicKey publicKey, byte[] data) throws Exception {
        ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
        SM2refPublicKey sm2refPublicKey = GMSSLSancConverUtils.converSM2RefPublicKey(publicKey);
        SM2refCipher sm2refCipher = cryptConnection.sm2Encrypt(sm2refPublicKey, data);
        ASN1SM2Cipher asn1SM2Cipher = new ASN1SM2Cipher(sm2refCipher.getX(), sm2refCipher.getY(), sm2refCipher.getM(), GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])sm2refCipher.getC(), (int)data.length));
        System.out.println(sm2refCipher.toString());
        return asn1SM2Cipher.getEncoded();
    }

    private static byte[] decryptAsn1BySanc(PrivateKey privateKey, byte[] data) throws Exception {
        ASN1SM2Cipher asn1SM2Cipher = ASN1SM2Cipher.getInstance((Object)data);
        ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
        SdfPrivateKey sancPrivate = (SdfPrivateKey)privateKey;
        assert (asn1SM2Cipher != null);
        System.out.println(data.length - 1 - 32 - 32 - 32);
        SM2refCipher sm2refCipher = new SM2refCipher(GMSSLByteArrayUtils.changeByteArrayLength((byte[])asn1SM2Cipher.getxCoordinate().toByteArray(), (int)32), GMSSLByteArrayUtils.changeByteArrayLength((byte[])asn1SM2Cipher.getyCoordinate().toByteArray(), (int)32), asn1SM2Cipher.getCipherText(), GMSSLByteArrayUtils.changeByteArrayLength((byte[])asn1SM2Cipher.getHash(), (int)32));
        System.out.println(sm2refCipher.toString());
        return cryptConnection.sm2Decrypt(sancPrivate.getIndex(), GMSSLSancKeyTypeEnum.ENCRYPT.getKeyType(), sm2refCipher);
    }

    public static String encryptByBC(PublicKey publicKey, String base64Data) throws CryptoException, IOException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPublicKeyParameters((PublicKey)publicKey);
        byte[] cipher = GMSSLSM2EncryptUtils.encryptByBC((ECKeyParameters)keyParameter, new SecureRandom(), data, 0, data.length);
        return GMSSLByteArrayUtils.base64Encode((byte[])cipher);
    }

    public static byte[] encryptByBC(PublicKey publicKey, byte[] data) throws CryptoException, IOException {
        AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPublicKeyParameters((PublicKey)publicKey);
        return GMSSLSM2EncryptUtils.encryptByBC((ECKeyParameters)keyParameter, new SecureRandom(), data, 0, data.length);
    }

    public static String encryptByYunhsm(PublicKey publicKey, String base64Data) throws Exception {
        return GMSSLSM2EncryptUtils.encryptBySdf(SdfCryptoType.YUNHSM, publicKey, base64Data);
    }

    public static String encryptByPcie(PublicKey publicKey, String base64Data) throws Exception {
        return GMSSLSM2EncryptUtils.encryptBySdf(SdfCryptoType.PCIE, publicKey, base64Data);
    }

    public static String encryptBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, String base64Data) throws Exception {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] sdfCipher = GMSSLSM2EncryptUtils.encryptBySdf(sdfCryptoType, publicKey, data, 0, data.length);
        return GMSSLByteArrayUtils.base64Encode((byte[])sdfCipher);
    }

    public static String decryptByBC(PrivateKey privateKey, String base64Data) throws IOException, InvalidCipherTextException {
        AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPrivateKeyKeyParameters((PrivateKey)privateKey);
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] out = GMSSLSM2EncryptUtils.decryptByBC((ECKeyParameters)keyParameter, data, 0, data.length);
        return GMSSLByteArrayUtils.base64Encode((byte[])out);
    }

    public static String decryptByYunhsm(int privateKeyIndex, String privateKeyPassword, String base64Data) throws Exception {
        return GMSSLSM2EncryptUtils.decryptBySdf(SdfCryptoType.YUNHSM, privateKeyIndex, privateKeyPassword, base64Data);
    }

    public static String decryptByPcie(int privateKeyIndex, String privateKeyPassword, String base64Data) throws Exception {
        return GMSSLSM2EncryptUtils.decryptBySdf(SdfCryptoType.PCIE, privateKeyIndex, privateKeyPassword, base64Data);
    }

    public static String decryptBySdf(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, String base64Data) throws Exception {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] out = GMSSLSM2EncryptUtils.decryptBySdf(sdfCryptoType, privateKeyIndex, privateKeyPassword, data, 0, data.length);
        return GMSSLByteArrayUtils.base64Encode((byte[])out);
    }

    public static String encryptASN1ByBC(PublicKey publicKey, String base64Data) throws CryptoException, IOException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] cipher = GMSSLSM2EncryptUtils.encryptASN1ByBC(publicKey, data);
        return GMSSLByteArrayUtils.base64Encode((byte[])cipher);
    }

    public static byte[] encryptASN1ByBC(PublicKey publicKey, byte[] data) throws CryptoException, IOException {
        AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPublicKeyParameters((PublicKey)publicKey);
        byte[] cipher = GMSSLSM2EncryptUtils.encryptASN1ByBC((ECKeyParameters)keyParameter, new SecureRandom(), data, 0, data.length);
        return cipher;
    }

    public static String encryptASN1ByYunhsm(PublicKey publicKey, String base64Data) throws Exception {
        return GMSSLSM2EncryptUtils.encryptASN1BySdf(SdfCryptoType.YUNHSM, publicKey, base64Data);
    }

    public static String encryptASN1ByPcie(PublicKey publicKey, String base64Data) throws Exception {
        return GMSSLSM2EncryptUtils.encryptASN1BySdf(SdfCryptoType.PCIE, publicKey, base64Data);
    }

    public static String encryptASN1BySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, String base64Data) throws Exception {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] sdfCipher = GMSSLSM2EncryptUtils.encryptASN1BySdf(sdfCryptoType, publicKey, data, 0, data.length);
        return GMSSLByteArrayUtils.base64Encode((byte[])sdfCipher);
    }

    public static String decryptASN1ByBC(PrivateKey privateKey, String base64Data) throws IOException, InvalidCipherTextException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] out = GMSSLSM2EncryptUtils.decryptASN1ByBC(privateKey, data);
        return GMSSLByteArrayUtils.base64Encode((byte[])out);
    }

    public static byte[] decryptASN1ByBC(PrivateKey privateKey, byte[] data) throws IOException, InvalidCipherTextException {
        AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPrivateKeyKeyParameters((PrivateKey)privateKey);
        byte[] out = GMSSLSM2EncryptUtils.decryptASN1ByBC((ECKeyParameters)keyParameter, data, 0, data.length);
        return out;
    }

    public static String decryptASN1ByYunhsm(int privateKeyIndex, String privateKeyPassword, String base64Data) throws Exception {
        return GMSSLSM2EncryptUtils.decryptASN1BySdf(SdfCryptoType.YUNHSM, privateKeyIndex, privateKeyPassword, base64Data);
    }

    public static String decryptASN1ByPcie(int privateKeyIndex, String privateKeyPassword, String base64Data) throws Exception {
        return GMSSLSM2EncryptUtils.decryptASN1BySdf(SdfCryptoType.PCIE, privateKeyIndex, privateKeyPassword, base64Data);
    }

    public static String decryptASN1BySdf(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, String base64Data) throws Exception {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] out = GMSSLSM2EncryptUtils.decryptASN1BySdf(sdfCryptoType, privateKeyIndex, privateKeyPassword, data, 0, data.length);
        return GMSSLByteArrayUtils.base64Encode((byte[])out);
    }

    public static byte[] encryptByBC(ECKeyParameters keyParameter, SecureRandom secureRandom, byte[] input, int inOff, int length) throws InvalidCipherTextException {
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)keyParameter, secureRandom));
        return sm2Engine.processBlock(input, inOff, length);
    }

    public static byte[] decryptByBC(ECKeyParameters keyParameter, byte[] input, int inOff, int length) throws InvalidCipherTextException {
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, (CipherParameters)keyParameter);
        return sm2Engine.processBlock(input, inOff, length);
    }

    public static byte[] encryptASN1ByBC(ECKeyParameters keyParameter, SecureRandom secureRandom, byte[] input, int inOff, int length) throws InvalidCipherTextException, IOException {
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)keyParameter, secureRandom));
        byte[] ciphertext = sm2Engine.processBlock(input, inOff, length);
        ECCurve curve = keyParameter.getParameters().getCurve();
        int curveLength = (curve.getFieldSize() + 7) / 8;
        byte[] c1 = new byte[curveLength * 2 + 1];
        System.arraycopy(ciphertext, inOff, c1, 0, c1.length);
        ECPoint c1P = curve.decodePoint(c1);
        byte[] xb = c1P.getXCoord().getEncoded();
        byte[] yb = c1P.getYCoord().getEncoded();
        SM3Digest digest = new SM3Digest();
        byte[] c2 = new byte[length];
        System.arraycopy(ciphertext, ciphertext.length - length - digest.getDigestSize(), c2, 0, length);
        byte[] c3 = new byte[digest.getDigestSize()];
        System.arraycopy(ciphertext, ciphertext.length - digest.getDigestSize(), c3, 0, digest.getDigestSize());
        ASN1SM2Cipher asn1SM2Cipher = new ASN1SM2Cipher(xb, yb, c3, c2);
        byte[] result = asn1SM2Cipher.toASN1Primitive().getEncoded();
        return result;
    }

    public static byte[] decryptASN1ByBC(ECKeyParameters keyParameter, byte[] input) throws InvalidCipherTextException {
        return GMSSLSM2EncryptUtils.decryptASN1ByBC(keyParameter, input, 0, input.length);
    }

    public static byte[] decryptASN1ByBC(ECKeyParameters keyParameter, byte[] input, int inOff, int length) throws InvalidCipherTextException {
        byte[] sm2CipherASN1 = new byte[length];
        System.arraycopy(input, inOff, sm2CipherASN1, 0, length);
        ASN1SM2Cipher asn1 = ASN1SM2Cipher.getInstance((Object)sm2CipherASN1);
        ECCurve curve = keyParameter.getParameters().getCurve();
        BigInteger x = asn1.getxCoordinate();
        BigInteger y = asn1.getyCoordinate();
        ECPoint point = curve.createPoint(x, y);
        byte[] c1 = point.getEncoded(false);
        byte[] c2 = asn1.getCipherText();
        byte[] c3 = asn1.getHash();
        byte[] ciphertext = Arrays.concatenate((byte[])c1, (byte[])c2, (byte[])c3);
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, (CipherParameters)keyParameter);
        byte[] M = sm2Engine.processBlock(ciphertext, 0, ciphertext.length);
        return M;
    }

    public static byte[] encryptBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, byte[] input, int inOff, int length) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer() || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLSM2EncryptUtils.encrypt(publicKey, input);
        }
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.DONGJIN_HSM) {
            sdfCryptoType = SdfCryptoType.DONGJIN;
        }
        SdfECEngine sdfECEngine = new SdfECEngine(sdfCryptoType);
        sdfECEngine.init(true, (CipherParameters)new SdfECKeyParameters((ECPublicKey)publicKey));
        byte[] sdfCipher = sdfECEngine.processBlock(input, inOff, length);
        sdfECEngine.release();
        return sdfCipher;
    }

    public static byte[] decryptBySdf(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, byte[] input, int inOff, int length) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer() || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLSM2EncryptUtils.decrypt((PrivateKey)new SdfPrivateKey(privateKeyIndex, privateKeyPassword), input);
        }
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.DONGJIN_HSM) {
            sdfCryptoType = SdfCryptoType.DONGJIN;
        }
        SdfECEngine sdfECEngineDecrypt = new SdfECEngine(sdfCryptoType);
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(privateKeyIndex, privateKeyPassword);
        sdfECEngineDecrypt.init(false, (CipherParameters)new SdfECKeyParameters(sdfPrivateKey));
        byte[] out = sdfECEngineDecrypt.processBlock(input, inOff, length);
        sdfECEngineDecrypt.release();
        return out;
    }

    public static byte[] encryptASN1BySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, byte[] input, int inOff, int length) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer() || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLSM2EncryptUtils.encryptAsn1Data(publicKey, input);
        }
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.DONGJIN_HSM) {
            sdfCryptoType = SdfCryptoType.DONGJIN;
        }
        SdfECEngine sdfECEngine = new SdfECEngine(sdfCryptoType);
        sdfECEngine.init(true, (CipherParameters)new SdfECKeyParameters((ECPublicKey)publicKey));
        byte[] sdfCipher = sdfECEngine.processBlockASN1(input, inOff, length);
        sdfECEngine.release();
        return sdfCipher;
    }

    public static byte[] decryptASN1BySdf(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, byte[] input, int inOff, int length) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer() || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLSM2EncryptUtils.decryptAsn1Cipher((PrivateKey)new SdfPrivateKey(privateKeyIndex, privateKeyPassword), input);
        }
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.DONGJIN_HSM) {
            sdfCryptoType = SdfCryptoType.DONGJIN;
        }
        SdfECEngine sdfECEngineDecrypt = new SdfECEngine(sdfCryptoType);
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(privateKeyIndex, privateKeyPassword);
        sdfECEngineDecrypt.init(false, (CipherParameters)new SdfECKeyParameters(sdfPrivateKey));
        byte[] out = sdfECEngineDecrypt.processBlockASN1(input, inOff, length);
        sdfECEngineDecrypt.release();
        return out;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

