/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;

public class GMSSLSdfFileUtils {
    public static void createFile(String fileName, int fileSize) throws Exception {
        GMSSLCryptoType cryptoType = GMSSLPkiCryptoInit.getSdfCryptoType();
        SdfSDK sdfSDK = cryptoType.getSdfCryptoType().getSdfSDK();
        sdfSDK.init();
        sdfSDK.createFile(fileName, fileSize);
        sdfSDK.release();
    }

    public static void writeFile(String fileName, int offset, byte[] context) throws Exception {
        GMSSLCryptoType cryptoType = GMSSLPkiCryptoInit.getSdfCryptoType();
        SdfSDK sdfSDK = cryptoType.getSdfCryptoType().getSdfSDK();
        sdfSDK.init();
        sdfSDK.writeFile(fileName, offset, context);
        sdfSDK.release();
    }

    public static void createAndWriteFile(String fileName, byte[] context) throws Exception {
        GMSSLCryptoType cryptoType = GMSSLPkiCryptoInit.getCryptoType();
        if (!cryptoType.checkSdfCryptoTypeSupport()) {
            throw new Exception("un support this crypto" + (Object)((Object)cryptoType));
        }
        int length = context.length;
        GMSSLSdfFileUtils.createFile(fileName, length);
        GMSSLSdfFileUtils.writeFile(fileName, 0, context);
    }

    public static byte[] readFile(String fileName, int offset, int length) throws Exception {
        GMSSLCryptoType cryptoType = GMSSLPkiCryptoInit.getSdfCryptoType();
        SdfSDK sdfSDK = cryptoType.getSdfCryptoType().getSdfSDK();
        sdfSDK.init();
        byte[] out = sdfSDK.readFile(fileName, offset, length);
        sdfSDK.release();
        return out;
    }

    public static void deleteFile(String fileName) throws Exception {
        GMSSLCryptoType cryptoType = GMSSLPkiCryptoInit.getSdfCryptoType();
        SdfSDK sdfSDK = cryptoType.getSdfCryptoType().getSdfSDK();
        sdfSDK.init();
        sdfSDK.deleteFile(fileName);
        sdfSDK.release();
    }
}

