/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.operator.utils;

import com.xdja.SafeKey.Sm2PublicKey;
import com.xdja.SafeKey.bean.MiniPcieIndexEnum;
import com.xdja.SafeKey.utils.MiniPcieXKFUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.io.OutputStream;
import java.security.PublicKey;
import java.security.SignatureException;

public class GMSSLXkfSignatureOutputStream
extends OutputStream {
    private int index;
    private String password;
    private PublicKey publicKey;
    private byte[] data = new byte[0];

    GMSSLXkfSignatureOutputStream(int index, String password) {
        this.index = index;
        this.password = password;
    }

    GMSSLXkfSignatureOutputStream(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        byte[] tmp = new byte[len];
        System.arraycopy(bytes, off, tmp, 0, len);
        this.data = GMSSLByteArrayUtils.mergeByteArray((byte[])this.data, (byte[])tmp);
    }

    @Override
    public void write(byte[] bytes) {
        this.data = GMSSLByteArrayUtils.mergeByteArray((byte[])this.data, (byte[])bytes);
    }

    @Override
    public void write(int var1) {
        byte[] tmp = new byte[]{(byte)var1};
        this.data = GMSSLByteArrayUtils.mergeByteArray((byte[])this.data, (byte[])tmp);
    }

    byte[] getSignature() throws Exception {
        return MiniPcieXKFUtils.sm2SignWithInternalHash((byte[])this.data, (byte[])MiniPcieIndexEnum.getInfoFromIndex((int)this.index).getSignPublicKeyIndex(), (byte[])MiniPcieIndexEnum.getInfoFromIndex((int)this.index).getSignPrivateIndex(), (String)this.password);
    }

    boolean verify(byte[] expected) throws Exception {
        try {
            return MiniPcieXKFUtils.sm2VerifyWithInternalHash((byte[])this.data, (byte[])expected, (Sm2PublicKey)new Sm2PublicKey(this.publicKey));
        }
        catch (SdfSDKException e) {
            throw new SignatureException("exception obtaining signature: " + e.getMessage(), e);
        }
    }
}

