/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.yunhsm.utils;

import com.dj.SJJ1805.HsmSJJ1805APIIns;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.dongjin.pool.HsmConnectionProviderImpl;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLIniFileUtils;
import com.xdja.pki.gmssl.x509.utils.bean.HsmInfoEntry;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmExceptionEnum;
import java.io.File;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLDongJinHsmUtils {
    private static Logger logger = LoggerFactory.getLogger(GMSSLDongJinHsmUtils.class);
    private static final String CONFIG_PATH;
    private static final String CONFIG_TEST_PATH;
    private static final String HSM_CONFIG_PATH;
    private static String CONFIG_INI_NAME;

    public static YunHsmExceptionEnum initYunHsmConfigAndTestConnect(String tomcatPath, String ip, int port, boolean isOtherTomcat) {
        try {
            String confPath = tomcatPath + HSM_CONFIG_PATH + CONFIG_PATH;
            YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLDongJinHsmUtils.testConnect(ip, port);
            if (yunHsmExceptionEnum != YunHsmExceptionEnum.NORMAL) {
                return yunHsmExceptionEnum;
            }
            GMSSLIniFileUtils.createDongJinHsmIni(confPath, ip, port);
            if (isOtherTomcat) {
                String thisConfigPath = GMSSLDongJinHsmUtils.getConfPath(false);
                GMSSLIniFileUtils.createDongJinHsmIni(thisConfigPath, ip, port);
            }
            GMSSLPkiCryptoInit.getDJHsmInstance();
            HsmConnectionProviderImpl.getInstance().reopen();
            return YunHsmExceptionEnum.NORMAL;
        }
        catch (Exception e) {
            logger.error("\u914d\u7f6e\u5bc6\u7801\u673a\u6d4b\u8bd5\u8fde\u901a\u6027\u5931\u8d25", (Throwable)e);
            return YunHsmExceptionEnum.OPEN_DEVICE_IS_FAILURE;
        }
    }

    public static YunHsmExceptionEnum initYunHsmConfigAndTestConnect(String ip, int port) {
        String tomcatPath = GMSSLDongJinHsmUtils.getTomcatPath();
        return GMSSLDongJinHsmUtils.initYunHsmConfigAndTestConnect(tomcatPath, ip, port, false);
    }

    public static YunHsmExceptionEnum testConnect(String ip, int port) {
        try {
            HsmSJJ1805APIIns singleConInstance = HsmSJJ1805APIIns.getSingleConInstance((String)ip, (int)port);
            if (!singleConInstance.isconnectedHsm().booleanValue()) {
                logger.error("\u6d4b\u8bd5\u8fde\u901a\u6027\u5931\u8d25");
                return YunHsmExceptionEnum.OPEN_DEVICE_IS_FAILURE;
            }
            singleConInstance.releaseSingleConInstance();
            return YunHsmExceptionEnum.NORMAL;
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5\u8fde\u901a\u6027\u5931\u8d25", (Throwable)e);
            return YunHsmExceptionEnum.OPEN_DEVICE_IS_FAILURE;
        }
    }

    public static YunHsmExceptionEnum testConnect() {
        try {
            HsmInfoEntry configInfo = GMSSLDongJinHsmUtils.getConfigInfo();
            return GMSSLDongJinHsmUtils.testConnect(configInfo.getIp(), configInfo.getPort());
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5\u8fde\u901a\u6027\u5931\u8d25", (Throwable)e);
            return YunHsmExceptionEnum.OPEN_DEVICE_IS_FAILURE;
        }
    }

    public static HsmInfoEntry getConfigInfo() {
        String iniPath = GMSSLDongJinHsmUtils.getConfPath(false) + File.separator + CONFIG_INI_NAME;
        String ip = GMSSLIniFileUtils.getProfileValue(iniPath, "EncryptorGroup_1_1", "SrvIPAddr");
        String port = GMSSLIniFileUtils.getProfileValue(iniPath, "EncryptorGroup_1_1", "SrvPort");
        HsmInfoEntry hsmInfoEntry = new HsmInfoEntry();
        hsmInfoEntry.setIp(ip);
        hsmInfoEntry.setPort(Integer.valueOf(port));
        return hsmInfoEntry;
    }

    public static String getConfPath(boolean isTest) {
        String confPath = GMSSLDongJinHsmUtils.getBaseConfPath();
        String path = isTest ? confPath + CONFIG_TEST_PATH : confPath + CONFIG_PATH;
        return path;
    }

    private static String getTomcatPath() {
        String tomcatPath = System.getProperty("catalina.home");
        if (null == tomcatPath || tomcatPath.contains("Temp")) {
            tomcatPath = "/home/xdja/dongjin";
        }
        return tomcatPath;
    }

    private static String getBaseConfPath() {
        return GMSSLDongJinHsmUtils.getTomcatPath() + HSM_CONFIG_PATH;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        CONFIG_PATH = File.separator + "conf";
        CONFIG_TEST_PATH = File.separator + "confTest";
        HSM_CONFIG_PATH = File.separator + "conf" + File.separator + "hsm";
        CONFIG_INI_NAME = "DJHsmAPI.ini";
    }
}

