/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.x509.utils;

import com.xdja.SafeKey.bean.MiniPcieIndexEnum;
import com.xdja.SafeKey.utils.MiniPcieXKFUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreBean;
import com.xdja.pki.gmssl.crypto.init.GMSSLHsmKeyStoreUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancContentSigner;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancContentVerifierProvider;
import com.xdja.pki.gmssl.operator.utils.GMSSLContentSignerUtils;
import com.xdja.pki.gmssl.operator.utils.GMSSLContentVerifierProviderUtils;
import com.xdja.pki.gmssl.operator.utils.GMSSLXkfContentSigner;
import com.xdja.pki.gmssl.operator.utils.GMSSLXkfContentVerifierProvider;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertException;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;

public class GMSSLCertUtils {
    public static X509Certificate generateCert(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey issuerKey, PublicKey subjectKey, String algorithm, List<Extension> extensions, boolean isWithParam) throws Exception {
        return GMSSLCertUtils.generateCert(issuer, subject, serial, notBefore, notAfter, issuerKey, subjectKey, algorithm, extensions, isWithParam, 256);
    }

    public static X509Certificate generateCert(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey issuerKey, PublicKey subjectKey, String algorithm, List<Extension> extensions, boolean isWithParam, int bits) throws Exception {
        return GMSSLCertUtils.generateCert(new X500Name(RFC4519Style.INSTANCE, issuer), new X500Name(RFC4519Style.INSTANCE, subject), serial, notBefore, notAfter, issuerKey, subjectKey, algorithm, extensions, isWithParam, bits);
    }

    public static X509Certificate generateCert(X500Name issuer, X500Name subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey issuerKey, PublicKey subjectKey, String algorithm, List<Extension> extensions, boolean isWithParam) throws Exception {
        return GMSSLCertUtils.generateCert(issuer, subject, serial, notBefore, notAfter, issuerKey, subjectKey, algorithm, extensions, isWithParam, 256);
    }

    public static X509Certificate generateCert(X500Name issuer, X500Name subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey issuerKey, PublicKey subjectKey, String algorithm, List<Extension> extensions, boolean isWithParam, int bits) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            SdfPrivateKey privateKey = (SdfPrivateKey)issuerKey;
            GMSSLHsmKeyStoreBean bean = GMSSLHsmKeyStoreUtils.getAsymKey(privateKey.getIndex(), false);
            return GMSSLCertUtils.generateCertByBC(issuer, subject, serial, notBefore, notAfter, bean.getPrivateKey(), subjectKey, algorithm, extensions, isWithParam);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                SdfPrivateKey pciePrivateKey = (SdfPrivateKey)issuerKey;
                return GMSSLCertUtils.generateCertByPcie(issuer, subject, serial, notBefore, notAfter, pciePrivateKey.getIndex(), pciePrivateKey.getStringPassword(), subjectKey, algorithm, extensions, isWithParam);
            }
            case XDJA_HSM: {
                SdfPrivateKey hsmPrivateKey = (SdfPrivateKey)issuerKey;
                ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByYunhsm(algorithm, (PrivateKey)hsmPrivateKey, isWithParam, bits);
                return GMSSLCertUtils.generateCert(issuer, subject, serial, notBefore, notAfter, subjectKey, contentSigner, extensions);
            }
            case DONGJIN_HSM: {
                SdfPrivateKey dJPrivateKey = (SdfPrivateKey)issuerKey;
                ContentSigner dJcontentSigner = GMSSLContentSignerUtils.generateContentSignerBySDF(SdfCryptoType.DONGJIN, algorithm, (PrivateKey)dJPrivateKey, isWithParam);
                return GMSSLCertUtils.generateCert(issuer, subject, serial, notBefore, notAfter, subjectKey, dJcontentSigner, extensions);
            }
            case MINI_PCI_E: {
                return GMSSLCertUtils.generateCertByMiniPcie(issuer, subject, serial, notBefore, notAfter, issuerKey, subjectKey, algorithm, extensions, isWithParam);
            }
            case SANC_HSM: {
                return GMSSLCertUtils.generateCertBySanc(issuer, subject, serial, notBefore, notAfter, issuerKey, subjectKey, algorithm, extensions, isWithParam);
            }
        }
        return GMSSLCertUtils.generateCertByBC(issuer, subject, serial, notBefore, notAfter, issuerKey, subjectKey, algorithm, extensions, isWithParam);
    }

    public static boolean verifyCert(PublicKey verifyKey, X509Certificate certificate) throws Exception {
        return GMSSLCertUtils.verifyCert(verifyKey, certificate, 256);
    }

    public static boolean verifyCert(PublicKey verifyKey, X509Certificate certificate, int bits) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            return GMSSLCertUtils.verifyCertByBC(verifyKey, certificate);
        }
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                return GMSSLCertUtils.verifyCertByPCIE(verifyKey, certificate);
            }
            case XDJA_HSM: {
                return GMSSLCertUtils.verifyCertByYunHsm(verifyKey, certificate, bits);
            }
            case DONGJIN_HSM: {
                return GMSSLCertUtils.verifyCertBySdf(SdfCryptoType.DONGJIN, verifyKey, certificate);
            }
            case MINI_PCI_E: {
                return GMSSLCertUtils.verifyCertByMiniPcie(verifyKey, certificate);
            }
            case SANC_HSM: {
                return GMSSLCertUtils.verifyCertBySanc(verifyKey, certificate);
            }
        }
        return GMSSLCertUtils.verifyCertByBC(verifyKey, certificate);
    }

    public static boolean writeCertToHardWare(int index, String password, X509Certificate certificate, boolean isEncryptCert) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case MINI_PCI_E: {
                if (isEncryptCert) {
                    return MiniPcieXKFUtils.writeCert((byte[])certificate.getEncoded(), (byte[])MiniPcieIndexEnum.getInfoFromIndex((int)index).getEncCertIndex(), (String)password);
                }
                return MiniPcieXKFUtils.writeCert((byte[])certificate.getEncoded(), (byte[])MiniPcieIndexEnum.getInfoFromIndex((int)index).getSignCertIndex(), (String)password);
            }
        }
        throw new Exception("un support writeCertToHardWare  with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static X509Certificate readCertFromHardWare(int index, boolean isEncryptCert) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case MINI_PCI_E: {
                if (isEncryptCert) {
                    byte[] certEncode = MiniPcieXKFUtils.readCert((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)index).getEncCertIndex());
                    return GMSSLX509Utils.readCertificateFromCerByte((byte[])certEncode);
                }
                byte[] certEncode = MiniPcieXKFUtils.readCert((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)index).getSignCertIndex());
                return GMSSLX509Utils.readCertificateFromCerByte((byte[])certEncode);
            }
        }
        throw new Exception("un support writeCertToHardWare  with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static X509Certificate generateCertBySanc(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey issuerKey, PublicKey subjectKey, String algorithm, List<Extension> extensions, boolean isWithParam) throws CertIOException, CertificateException {
        return GMSSLCertUtils.generateCertBySanc(new X500Name(RFC4519Style.INSTANCE, issuer), new X500Name(RFC4519Style.INSTANCE, subject), serial, notBefore, notAfter, issuerKey, subjectKey, algorithm, extensions, isWithParam);
    }

    public static X509Certificate generateCertBySanc(X500Name issuer, X500Name subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey issuerKey, PublicKey subjectKey, String algorithm, List<Extension> extensions, boolean isWithParam) throws CertIOException, CertificateException {
        GMSSLSancContentSigner contentSigner = new GMSSLSancContentSigner(algorithm, issuerKey, isWithParam);
        return GMSSLCertUtils.generateCert(issuer, subject, serial, notBefore, notAfter, subjectKey, contentSigner, extensions);
    }

    public static boolean verifyCertBySanc(PublicKey publicKey, X509Certificate certificate) throws Exception {
        GMSSLSancContentVerifierProvider contentVerifierProvider = new GMSSLSancContentVerifierProvider(publicKey);
        return GMSSLCertUtils.verifyCert((ContentVerifierProvider)contentVerifierProvider, certificate);
    }

    public static X509Certificate generateCertByMiniPcie(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey issuerKey, PublicKey subjectKey, String algorithm, List<Extension> extensions, boolean isWithParam) throws CertIOException, CertificateException {
        return GMSSLCertUtils.generateCertByMiniPcie(new X500Name(RFC4519Style.INSTANCE, issuer), new X500Name(RFC4519Style.INSTANCE, subject), serial, notBefore, notAfter, issuerKey, subjectKey, algorithm, extensions, isWithParam);
    }

    public static X509Certificate generateCertByMiniPcie(X500Name issuer, X500Name subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey issuerKey, PublicKey subjectKey, String algorithm, List<Extension> extensions, boolean isWithParam) throws CertIOException, CertificateException {
        GMSSLXkfContentSigner contentSigner = new GMSSLXkfContentSigner(algorithm, issuerKey, isWithParam);
        return GMSSLCertUtils.generateCert(issuer, subject, serial, notBefore, notAfter, subjectKey, contentSigner, extensions);
    }

    public static boolean verifyCertByMiniPcie(PublicKey publicKey, X509Certificate certificate) throws Exception {
        GMSSLXkfContentVerifierProvider contentVerifierProvider = new GMSSLXkfContentVerifierProvider(publicKey);
        return GMSSLCertUtils.verifyCert((ContentVerifierProvider)contentVerifierProvider, certificate);
    }

    public static X509Certificate generateCertByBC(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey issuerKey, PublicKey subjectKey, String algorithm, List<Extension> extensions) throws Exception {
        return GMSSLCertUtils.generateCertByBC(new X500Name(RFC4519Style.INSTANCE, issuer), new X500Name(RFC4519Style.INSTANCE, subject), serial, notBefore, notAfter, issuerKey, subjectKey, algorithm, extensions, false);
    }

    public static X509Certificate generateCertByBC(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey issuerKey, PublicKey subjectKey, String algorithm, List<Extension> extensions, boolean isWithParam) throws Exception {
        return GMSSLCertUtils.generateCertByBC(new X500Name(RFC4519Style.INSTANCE, issuer), new X500Name(RFC4519Style.INSTANCE, subject), serial, notBefore, notAfter, issuerKey, subjectKey, algorithm, extensions, isWithParam);
    }

    public static X509Certificate generateCertByBC(X500Name issuer, X500Name subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey issuerKey, PublicKey subjectKey, String algorithm, List<Extension> extensions) throws Exception {
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByBC(algorithm, issuerKey);
        return GMSSLCertUtils.generateCert(issuer, subject, serial, notBefore, notAfter, subjectKey, contentSigner, extensions);
    }

    public static X509Certificate generateCertByBC(X500Name issuer, X500Name subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey issuerKey, PublicKey subjectKey, String algorithm, List<Extension> extensions, boolean isWithParam) throws Exception {
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByBC(algorithm, issuerKey, isWithParam);
        return GMSSLCertUtils.generateCert(issuer, subject, serial, notBefore, notAfter, subjectKey, contentSigner, extensions);
    }

    public static X509Certificate generateCertByYunhsm(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, int issuerKeyIndex, String issuerKeyPassword, PublicKey subjectKey, String algorithm, List<Extension> extensions) throws Exception {
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(issuerKeyIndex, issuerKeyPassword);
        return GMSSLCertUtils.generateCertByYunhsm(issuer, subject, serial, notBefore, notAfter, (PrivateKey)sdfPrivateKey, subjectKey, algorithm, extensions);
    }

    public static X509Certificate generateCertByYunhsm(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, int issuerKeyIndex, String issuerKeyPassword, PublicKey subjectKey, String algorithm, List<Extension> extensions, boolean isWithParam) throws Exception {
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(issuerKeyIndex, issuerKeyPassword);
        return GMSSLCertUtils.generateCertByYunhsm(issuer, subject, serial, notBefore, notAfter, (PrivateKey)sdfPrivateKey, subjectKey, algorithm, extensions, isWithParam);
    }

    public static X509Certificate generateCertByYunhsm(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey sdfPrivateKey, PublicKey subjectKey, String algorithm, List<Extension> extensions) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer() || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.DONGJIN_HSM) {
            return GMSSLCertUtils.generateCert(issuer, subject, serial, notBefore, notAfter, sdfPrivateKey, subjectKey, algorithm, extensions, false);
        }
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByYunhsm(algorithm, sdfPrivateKey);
        return GMSSLCertUtils.generateCert(new X500Name(RFC4519Style.INSTANCE, issuer), new X500Name(RFC4519Style.INSTANCE, subject), serial, notBefore, notAfter, subjectKey, contentSigner, extensions);
    }

    public static X509Certificate generateCertByYunhsm(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey sdfPrivateKey, PublicKey subjectKey, String algorithm, List<Extension> extensions, boolean isWithParam) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer() || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.DONGJIN_HSM) {
            return GMSSLCertUtils.generateCert(issuer, subject, serial, notBefore, notAfter, sdfPrivateKey, subjectKey, algorithm, extensions, isWithParam);
        }
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByYunhsm(algorithm, sdfPrivateKey, isWithParam);
        return GMSSLCertUtils.generateCert(new X500Name(RFC4519Style.INSTANCE, issuer), new X500Name(RFC4519Style.INSTANCE, subject), serial, notBefore, notAfter, subjectKey, contentSigner, extensions);
    }

    public static X509Certificate generateCertByYunhsm(X500Name issuer, X500Name subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey sdfPrivateKey, PublicKey subjectKey, String algorithm, List<Extension> extensions, boolean isWithParam) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            SdfPrivateKey privateKey = (SdfPrivateKey)sdfPrivateKey;
            GMSSLHsmKeyStoreBean bean = GMSSLHsmKeyStoreUtils.getAsymKey(privateKey.getIndex(), false);
            return GMSSLCertUtils.generateCertByBC(issuer, subject, serial, notBefore, notAfter, bean.getPrivateKey(), subjectKey, algorithm, extensions);
        }
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByYunhsm(algorithm, sdfPrivateKey, isWithParam);
        return GMSSLCertUtils.generateCert(issuer, subject, serial, notBefore, notAfter, subjectKey, contentSigner, extensions);
    }

    public static X509Certificate generateCertByPcie(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, int issuerKeyIndex, String issuerKeyPassword, PublicKey subjectKey, String algorithm, List<Extension> extensions) throws Exception {
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(issuerKeyIndex, issuerKeyPassword);
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByPcie(algorithm, (PrivateKey)sdfPrivateKey);
        return GMSSLCertUtils.generateCert(new X500Name(RFC4519Style.INSTANCE, issuer), new X500Name(RFC4519Style.INSTANCE, subject), serial, notBefore, notAfter, subjectKey, contentSigner, extensions);
    }

    public static X509Certificate generateCertByPcie(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, int issuerKeyIndex, String issuerKeyPassword, PublicKey subjectKey, String algorithm, List<Extension> extensions, boolean isWithParam) throws Exception {
        return GMSSLCertUtils.generateCertByPcie(new X500Name(RFC4519Style.INSTANCE, issuer), new X500Name(RFC4519Style.INSTANCE, subject), serial, notBefore, notAfter, issuerKeyIndex, issuerKeyPassword, subjectKey, algorithm, extensions, isWithParam);
    }

    public static X509Certificate generateCertByPcie(X500Name issuer, X500Name subject, BigInteger serial, Date notBefore, Date notAfter, int issuerKeyIndex, String issuerKeyPassword, PublicKey subjectKey, String algorithm, List<Extension> extensions, boolean isWithParam) throws CertIOException, OperatorCreationException, CertificateException {
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(issuerKeyIndex, issuerKeyPassword);
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByPcie(algorithm, (PrivateKey)sdfPrivateKey, isWithParam);
        return GMSSLCertUtils.generateCert(issuer, subject, serial, notBefore, notAfter, subjectKey, contentSigner, extensions);
    }

    public static X509Certificate generateCert(X500Name issuer, X500Name subject, BigInteger serial, Date notBefore, Date notAfter, PublicKey subjectKey, ContentSigner contentSigner, List<Extension> extensions) throws CertIOException, CertificateException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = GMSSLX509Utils.convertSubjectPublicKeyInfo((PublicKey)subjectKey);
        X509v3CertificateBuilder builder = new X509v3CertificateBuilder(issuer, serial, notBefore, notAfter, subject, subjectPublicKeyInfo);
        if (extensions != null) {
            for (Extension extension : extensions) {
                builder.addExtension(extension);
            }
        }
        X509CertificateHolder holder = builder.build(contentSigner);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(holder);
    }

    public static X509Certificate decodeCertByBC(PublicKey publicKey, byte[] certEncode) throws OperatorCreationException, CertificateException, IOException, CertException {
        ContentVerifierProvider contentVerifierProvider = GMSSLContentVerifierProviderUtils.generateContentVerifierByBC(publicKey);
        return GMSSLCertUtils.decodeCert(contentVerifierProvider, certEncode);
    }

    public static X509Certificate decodeCertByYunhsm(PublicKey publicKey, byte[] certEncode) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer()) {
            return GMSSLCertUtils.decodeCertByBC(publicKey, certEncode);
        }
        return GMSSLCertUtils.decodeCertBySdf(SdfCryptoType.YUNHSM, publicKey, certEncode);
    }

    public static X509Certificate decodeCertByPcie(PublicKey publicKey, byte[] certEncode) throws CertificateException, IOException, CertException {
        return GMSSLCertUtils.decodeCertBySdf(SdfCryptoType.PCIE, publicKey, certEncode);
    }

    public static X509Certificate decodeCertBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, byte[] certEncode) throws CertificateException, IOException, CertException {
        ContentVerifierProvider contentVerifierProvider = GMSSLContentVerifierProviderUtils.generateContentVerifierBySdf(sdfCryptoType, publicKey);
        return GMSSLCertUtils.decodeCert(contentVerifierProvider, certEncode);
    }

    public static X509Certificate decodeCert(byte[] certEncode) throws IOException, CertException, CertificateException {
        X509CertificateHolder holder = new X509CertificateHolder(certEncode);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(holder);
    }

    public static X509Certificate decodeCert(ContentVerifierProvider contentVerifierProvider, byte[] certEncode) throws IOException, CertException, CertificateException {
        X509CertificateHolder holder = new X509CertificateHolder(certEncode);
        holder.isSignatureValid(contentVerifierProvider);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(holder);
    }

    public static boolean verifyCertByBC(PublicKey publicKey, X509Certificate cert) throws Exception {
        ContentVerifierProvider contentVerifierProvider = GMSSLContentVerifierProviderUtils.generateContentVerifierByBC(publicKey);
        return GMSSLCertUtils.verifyCert(contentVerifierProvider, cert);
    }

    public static boolean verifyCertByYunHsm(PublicKey publicKey, X509Certificate cert) throws Exception {
        return GMSSLCertUtils.verifyCertByYunHsm(publicKey, cert, 256);
    }

    public static boolean verifyCertByYunHsm(PublicKey publicKey, X509Certificate cert, int bits) throws Exception {
        return GMSSLCertUtils.verifyCertBySdf(SdfCryptoType.YUNHSM, publicKey, cert, bits);
    }

    public static boolean verifyCertByPCIE(PublicKey publicKey, X509Certificate cert) throws Exception {
        return GMSSLCertUtils.verifyCertBySdf(SdfCryptoType.PCIE, publicKey, cert);
    }

    public static boolean verifyCertBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, X509Certificate cert) throws Exception {
        return GMSSLCertUtils.verifyCertBySdf(sdfCryptoType, publicKey, cert, 256);
    }

    public static boolean verifyCertBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, X509Certificate cert, int bits) throws Exception {
        if (GMSSLPkiCryptoInit.isHsmServer() || GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLCertUtils.verifyCert(publicKey, cert);
        }
        ContentVerifierProvider contentVerifierProvider = GMSSLContentVerifierProviderUtils.generateContentVerifierBySdf(sdfCryptoType, publicKey, bits);
        return GMSSLCertUtils.verifyCert(contentVerifierProvider, cert);
    }

    public static boolean verifyCert(ContentVerifierProvider verifierProvider, X509Certificate cert) throws Exception {
        return GMSSLCertUtils.verifyCert(verifierProvider, cert.getEncoded());
    }

    public static boolean verifyCert(ContentVerifierProvider verifierProvider, byte[] cert) throws Exception {
        X509CertificateHolder holder = new X509CertificateHolder(cert);
        return holder.isSignatureValid(verifierProvider);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

