package com.xdja.pki.gmssl.sdf;

import com.xdja.pki.gmssl.sdf.bean.*;

import java.security.KeyPair;

public interface SdfSDK {

    void init() throws SdfSDKException;

    void release() throws SdfSDKException;

    byte[] generateRandom(int uiLength) throws SdfSDKException;

    SdfECCKeyPair generateKeyPairEcc() throws SdfSDKException;

    boolean checkPrivateKeyAccessRight(int index, byte[] password) throws SdfSDKException;

    SdfECCSignature internalSignECC(int index, byte[] password, byte[] data) throws SdfSDKException;

    SdfECCPublicKey exportSignPublicKeyEcc(int index) throws SdfSDKException;

    void externalVerifyECC(SdfECCPublicKey key, byte[] data, SdfECCSignature pucSignature) throws SdfSDKException;

    SdfECCPublicKey exportEncPublicKeyEcc(int index) throws SdfSDKException;

    SdfECCCipher externalEncryptECC(SdfECCPublicKey publicKey, byte[] data) throws SdfSDKException;

    byte[] internalDecryptECC(int index, byte[] password, int len, SdfECCCipher pucEncData) throws SdfSDKException;

    SdfECCCipher generateKeyWithEpkEcc(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException;

    long[] generateKeyWithEpkEccHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException;

    long[] importKeyWithIskEcc(int uiIskIndex, byte[] password, SdfECCCipher sdfECCCipher) throws SdfSDKException;

    SdfSymmetricKeyHandle generateKeyWithEpkEccKeyHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException;

    long[] importKey(byte[] pucKey) throws SdfSDKException;

    byte[] encrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] pucIv, byte[] pucData) throws SdfSDKException;

    byte[] decrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] pucIv, byte[] pucEncData) throws SdfSDKException;

    void destroyKey(long[] phKeyHandle) throws SdfSDKException;

    void hashInit(SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException;

    void hashInit(SdfAlgIdHash sdfAlgIdHash, byte[] pucID, SdfECCPublicKey publicKey) throws SdfSDKException;

    void hashUpdate(byte[] data) throws SdfSDKException;

    byte[] hashFinal(int digestLen) throws SdfSDKException;

    void calculateMac(int uiKeyIndex) throws SdfSDKException;

    byte[] sm3Hmac(byte[] dataIn, byte[] key) throws SdfSDKException;

    SdfRSAPublicKey exportSignPublicKeyRsa(int index) throws SdfSDKException;

    SdfRSAPublicKey exportEncPublicKeyRsa(int index) throws SdfSDKException;

    SdfRsaKeyPair generateKeyPairRsa(int bits) throws SdfSDKException;

    byte[] externalPublicKeyOperationRsa(SdfRSAPublicKey sdfRSAPublicKey, byte[] data) throws SdfSDKException;

    byte[] internalPrivateKeyOperationRsa(int index, byte[] password, byte[] data) throws SdfSDKException ;


}
