package com.xdja.pki.gmssl.sdf;

import com.xdja.pki.gmssl.sdf.bean.SdfApiCode;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSdfSDK implements SdfSDK {

    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected long[] dev = {0}, ses = {0};

    protected void checkRet(String method, int ret) throws SdfSDKException {
        if (ret != 0) {
            logger.error(method + " error! dev = " + dev[0] + " session = " + ses[0] + " ret = " + ret + " HEX = " + Integer.toHexString(ret));
            if (ret == SdfApiCode.SDR_COMMFAIL){
                this.release();
                this.init();
                logger.error(method + " next error! dev = " + dev[0] + " session = " + ses[0] + " ret = " + ret + " HEX = " + Integer.toHexString(ret));
                throw new SdfSDKException(method, ret);
            }
            throw new SdfSDKException(method, ret);
        } else {
//            logger.info(method + " success! dev = " + dev[0] + " session = " + ses[0]);
        }
    }

}
