package com.xdja.pki.gmssl.sdf;

import com.xdja.pki.gmssl.sdf.bean.*;

import java.security.KeyPair;

public interface SdfSDK {

    void init() throws SdfSDKException;

    void release() throws SdfSDKException;

    byte[] generateRandom(int uiLength) throws SdfSDKException;

    SdfECCKeyPair generateKeyPairEcc() throws SdfSDKException;

    SdfECCKeyPair generateKeyPairEcc(int algId) throws SdfSDKException;

    boolean checkPrivateKeyAccessRight(int index, byte[] password) throws SdfSDKException;

    SdfECCSignature internalSignECC(int index, byte[] password, byte[] data) throws SdfSDKException;

    SdfECCPublicKey exportSignPublicKeyEcc(int index) throws SdfSDKException;

    void externalVerifyECC(SdfECCPublicKey key, byte[] data, SdfECCSignature pucSignature) throws SdfSDKException;

    void externalVerifyECC(SdfECCPublicKey publicKey, byte[] data, SdfECCSignature sdfECCSignature, String signAlgName) throws SdfSDKException;

    SdfECCPublicKey exportEncPublicKeyEcc(int index) throws SdfSDKException;

    SdfECCCipher externalEncryptECC(SdfECCPublicKey publicKey, byte[] data) throws SdfSDKException;

    SdfECCCipher externalEncryptECC(SdfECCPublicKey publicKey, byte[] data, String stdName) throws SdfSDKException;

    byte[] internalDecryptECC(int index, byte[] password, int len, SdfECCCipher pucEncData) throws SdfSDKException;

    byte[] internalDecryptECC(int index, byte[] password, int len, SdfECCCipher sdfECCCipher, String stdName) throws SdfSDKException;

    SdfECCCipher generateKeyWithEpkEcc(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException;

    long[] generateKeyWithEpkEccHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException;

    long[] importKeyWithIskEcc(int uiIskIndex, byte[] password, SdfECCCipher sdfECCCipher) throws SdfSDKException;

    SdfSymmetricKeyHandle generateKeyWithEpkEccKeyHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException;

    long[] importKey(byte[] pucKey) throws SdfSDKException;

    byte[] encrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] pucIv, byte[] pucData) throws SdfSDKException;

    byte[] decrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] pucIv, byte[] pucEncData) throws SdfSDKException;

    void destroyKey(long[] phKeyHandle) throws SdfSDKException;

    void hashInit(SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException;

    void hashInit(SdfAlgIdHash sdfAlgIdHash, byte[] pucID, SdfECCPublicKey publicKey) throws SdfSDKException;

    void hashUpdate(byte[] data) throws SdfSDKException;

    byte[] hashFinal(int digestLen) throws SdfSDKException;

    void calculateMac(int uiKeyIndex) throws SdfSDKException;

    byte[] sm3Hmac(byte[] dataIn, byte[] key) throws SdfSDKException;

    SdfRSAPublicKey exportSignPublicKeyRsa(int index) throws SdfSDKException;

    SdfRSAPublicKey exportEncPublicKeyRsa(int index) throws SdfSDKException;

    SdfRsaKeyPair generateKeyPairRsa(int bits) throws SdfSDKException;

    byte[] externalPublicKeyOperationRsa(SdfRSAPublicKey sdfRSAPublicKey, byte[] data) throws SdfSDKException;

    byte[] internalPrivateKeyOperationRsa(int index, byte[] password, byte[] data) throws SdfSDKException;

    /**
     * AEAD 加密 对称消息验证码认证加密
     *
     * @param phKeyHandle key 所在的密钥句柄
     * @param uiAlgId     算法标识
     * @param tagLen      消息验证码长度
     * @param nonce       nonce 特定数据
     * @param aad         aad 附加数据
     * @param data        明文数据 待加密数据
     * @return 输出 密文数据 + 校验码 ： cipher || tag
     */
    byte[] encryptAead(long[] phKeyHandle, int uiAlgId, int tagLen, byte[] nonce, byte[] aad, byte[] data) throws SdfSDKException;

    /**
     * AEAD 解密 对称消息验证码认证解密
     *
     * @param phKeyHandle key 所在的密钥句柄
     * @param uiAlgId     算法标识
     * @param tagLen      消息验证码长度
     * @param nonce       nonce 特定数据
     * @param aad         aad 附加数据
     * @param enc         密文数据 待解密数据
     * @return 输出 明文数据 + 校验码 ： plaintext || tag
     */
    byte[] decryptAead(long[] phKeyHandle, int uiAlgId, int tagLen, byte[] nonce, byte[] aad, byte[] enc) throws SdfSDKException;

}
