package com.xdja.pki.gmssl.sdf.bean;

public enum SdfAlgIdSignature {

    /*****************************
     * 签名算法标识
     *****************************/

    /**
     * 基于SM3算法和RSA算法的签名
     */
    SGD_SM3_RSA(0x00010001, "SGD_SM3_RSA"),

    /**
     * 基于SHA_1算法和RSA算法的签名
     */
    SGD_SHA1_RSA(0x00010002, "SGD_SHA1_RSA"),

    /**
     * 基于SHA_256算法和RSA算法的签名
     */
    SGD_SHA256_RSA(0x00010004, "SGD_SHA256_RSA"),

    /**
     * 基于SM3算法和SM2算法的签名
     */
    SGD_SM3_SM2(0x00020201, "SGD_SM3_SM2");

    private int id;
    private String name;

    SdfAlgIdSignature(int id, String name){
        this.id = id;
        this.name = name;
    }

    public int getId(){
        return this.id;
    }

    public String getName() {
        return name;
    }

    @Override
    public String toString() {
        return "SdfAlgIdSymmetric{" +
                "id=" + id +
                ", name='" + name + '\'' +
                '}';
    }
}
