package com.xdja.pki.gmssl.sdf.bean;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import org.bouncycastle.util.encoders.Hex;

import java.util.Arrays;

public class SdfECCPrivateKey {
    private byte[] k;

    public static SdfECCPrivateKey getInstanceFilterHead(byte[] k){
        return new SdfECCPrivateKey(
                GMSSLByteArrayUtils.filterByteArrayZeroInHead(k)
        );
    }

    public static SdfECCPrivateKey getInstanceFilterFoot(byte[] k){
        return new SdfECCPrivateKey(
                GMSSLByteArrayUtils.filterByteArrayZeroInFoot(k)
        );
    }

    private SdfECCPrivateKey(byte[] k) {
        this.k = k;
    }

    public byte[] getK() {
        return k;
    }

    public void setK(byte[] k) {
        this.k = k;
    }

    @Override
    public String toString() {
        return "SdfECCPrivateKey{" +
                "k=" + Hex.toHexString(k) +
                '}';
    }
}
