package com.xdja.pki.gmssl.sdf.bean;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;

import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

/**
 * @ClassName SdfRSAPublicKey
 * @Date 2019/8/30 9:13
 * @Author FengZhen
 */
public class SdfRSAPublicKey {

    /**
     * 模长
     */
    private int bits;
    /**
     * 模N
     */
    private byte[] m;
    /**
     * 公钥指数
     */
    private byte[] e;

    public SdfRSAPublicKey() {
        super();
    }

    public SdfRSAPublicKey(int bits, byte[] m, byte[] e) {
        super();
        this.bits = bits;
        this.m = m;
        this.e = e;
    }

    public static SdfRSAPublicKey getInstance(RSAPublicKey rsaPublicKey) {
        int bitLength = rsaPublicKey.getModulus().bitLength();
        return new SdfRSAPublicKey(
                bitLength,
                GMSSLByteArrayUtils.asUnsignedByteArray(rsaPublicKey.getModulus(), bitLength / 8),
                GMSSLByteArrayUtils.asUnsignedByteArray(rsaPublicKey.getPublicExponent(), bitLength / 8)
        );
    }

    public static SdfRSAPublicKey getInstance(int bits, BigInteger m, BigInteger e) {
        return new SdfRSAPublicKey(
                bits,
                GMSSLByteArrayUtils.asUnsignedByteArray(m, bits / 8),
                GMSSLByteArrayUtils.asUnsignedByteArray(e, bits / 8)
        );
    }

    public static SdfRSAPublicKey getInstanceFilterHead(int bits, byte[] m, byte[] e) {
        return new SdfRSAPublicKey(
                bits,
                GMSSLByteArrayUtils.filterByteArrayZeroInHead(m, bits / 8),
                GMSSLByteArrayUtils.filterByteArrayZeroInHead(e, bits / 8)
        );
    }

    public static SdfRSAPublicKey getInstanceFilterFoot(int bits, byte[] m, byte[] e) {
        return new SdfRSAPublicKey(
                bits,
                GMSSLByteArrayUtils.filterByteArrayZeroInFoot(m, bits / 8),
                GMSSLByteArrayUtils.filterByteArrayZeroInFoot(e, bits / 8)
        );
    }

    public int getBits() {
        return bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public byte[] getM() {
        return m;
    }

    public void setM(byte[] m) {
        this.m = m;
    }

    public byte[] getE() {
        return e;
    }

    public void setE(byte[] e) {
        this.e = e;
    }

    @Override
    public String toString() {
        return "SdfRSAPublicKey{" +
                "bits=" + bits +
                ", m=" + Arrays.toString(m) +
                ", e=" + Arrays.toString(e) +
                '}';
    }
}
