/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.bean;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;

public class SdfECCPublicKey {
    private byte[] x;
    private byte[] y;
    private int bits = 256;

    public static SdfECCPublicKey getInstance(ECPublicKey ecPublicKey) {
        return new SdfECCPublicKey(GMSSLByteArrayUtils.asUnsignedByteArray32((BigInteger)ecPublicKey.getW().getAffineX()), GMSSLByteArrayUtils.asUnsignedByteArray32((BigInteger)ecPublicKey.getW().getAffineY()));
    }

    public static SdfECCPublicKey getInstance(BigInteger x, BigInteger y) {
        return new SdfECCPublicKey(GMSSLByteArrayUtils.asUnsignedByteArray32((BigInteger)x), GMSSLByteArrayUtils.asUnsignedByteArray32((BigInteger)y));
    }

    public static SdfECCPublicKey getInstanceFilterHead(byte[] x, byte[] y) {
        return new SdfECCPublicKey(GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])x), GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])y));
    }

    public static SdfECCPublicKey getInstanceFilterHead(byte[] x, byte[] y, int bits) {
        return new SdfECCPublicKey(GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])x, (int)bits), GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])y, (int)bits));
    }

    public static SdfECCPublicKey getInstanceFilterFoot(byte[] x, byte[] y) {
        return new SdfECCPublicKey(GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])x), GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])y));
    }

    private SdfECCPublicKey(byte[] x, byte[] y) {
        this.x = x;
        this.y = y;
    }

    public SdfECCPublicKey(byte[] x, byte[] y, int bits) {
        this.x = x;
        this.y = y;
        this.bits = bits;
    }

    public byte[] getX() {
        return this.x;
    }

    public void setX(byte[] x) {
        this.x = x;
    }

    public byte[] getY() {
        return this.y;
    }

    public void setY(byte[] y) {
        this.y = y;
    }

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public String toString() {
        return "SdfECCPublicKey{x=" + Arrays.toString(this.x) + ", y=" + Arrays.toString(this.y) + ", bits=" + this.bits + '}';
    }
}

