/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.bean;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

public class SdfRSAPublicKey {
    private int bits;
    private byte[] m;
    private byte[] e;

    public SdfRSAPublicKey() {
    }

    public SdfRSAPublicKey(int bits, byte[] m, byte[] e) {
        this.bits = bits;
        this.m = m;
        this.e = e;
    }

    public static SdfRSAPublicKey getInstance(RSAPublicKey rsaPublicKey) {
        int bitLength = rsaPublicKey.getModulus().bitLength();
        return new SdfRSAPublicKey(bitLength, GMSSLByteArrayUtils.asUnsignedByteArray((BigInteger)rsaPublicKey.getModulus(), (int)(bitLength / 8)), GMSSLByteArrayUtils.asUnsignedByteArray((BigInteger)rsaPublicKey.getPublicExponent(), (int)(bitLength / 8)));
    }

    public static SdfRSAPublicKey getInstance(int bits, BigInteger m, BigInteger e) {
        return new SdfRSAPublicKey(bits, GMSSLByteArrayUtils.asUnsignedByteArray((BigInteger)m, (int)(bits / 8)), GMSSLByteArrayUtils.asUnsignedByteArray((BigInteger)e, (int)(bits / 8)));
    }

    public static SdfRSAPublicKey getInstanceFilterHead(int bits, byte[] m, byte[] e) {
        return new SdfRSAPublicKey(bits, GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])m, (int)(bits / 8)), GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])e, (int)(bits / 8)));
    }

    public static SdfRSAPublicKey getInstanceFilterFoot(int bits, byte[] m, byte[] e) {
        return new SdfRSAPublicKey(bits, GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])m, (int)(bits / 8)), GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])e, (int)(bits / 8)));
    }

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public byte[] getM() {
        return this.m;
    }

    public void setM(byte[] m) {
        this.m = m;
    }

    public byte[] getE() {
        return this.e;
    }

    public void setE(byte[] e) {
        this.e = e;
    }

    public String toString() {
        return "SdfRSAPublicKey{bits=" + this.bits + ", m=" + Arrays.toString(this.m) + ", e=" + Arrays.toString(this.e) + '}';
    }
}

