/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.bean;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import org.bouncycastle.util.BigIntegers;

public class SdfRSAPrivateKey {
    private int bits;
    private byte[] m;
    private byte[] e;
    private byte[] d;
    private byte[][] prime;
    private byte[][] pexp;
    private byte[] coef;

    public SdfRSAPrivateKey() {
    }

    public SdfRSAPrivateKey(int bits, byte[] m, byte[] e, byte[] d, byte[][] prime, byte[][] pexp, byte[] coef) {
        this.bits = bits;
        this.m = m;
        this.e = e;
        this.d = d;
        this.prime = prime;
        this.pexp = pexp;
        this.coef = coef;
    }

    public static SdfRSAPrivateKey getInstance(BCRSAPrivateCrtKey privateCrtKey) {
        byte[][] prime = new byte[][]{GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)privateCrtKey.getPrimeP()), (int)128), GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)privateCrtKey.getPrimeQ()), (int)128)};
        byte[][] pexp = new byte[][]{GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)privateCrtKey.getPrimeExponentP()), (int)128), GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)privateCrtKey.getPrimeExponentQ()), (int)128)};
        int bitLength = privateCrtKey.getModulus().bitLength();
        return new SdfRSAPrivateKey(bitLength, GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)privateCrtKey.getModulus()), (int)256), GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)privateCrtKey.getPublicExponent()), (int)256), GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)privateCrtKey.getPrivateExponent()), (int)256), prime, pexp, GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)privateCrtKey.getCrtCoefficient()), (int)128));
    }

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public byte[] getM() {
        return this.m;
    }

    public void setM(byte[] m) {
        this.m = m;
    }

    public byte[] getE() {
        return this.e;
    }

    public void setE(byte[] e) {
        this.e = e;
    }

    public byte[] getD() {
        return this.d;
    }

    public void setD(byte[] d) {
        this.d = d;
    }

    public byte[][] getPrime() {
        return this.prime;
    }

    public void setPrime(byte[][] prime) {
        this.prime = prime;
    }

    public byte[][] getPexp() {
        return this.pexp;
    }

    public void setPexp(byte[][] pexp) {
        this.pexp = pexp;
    }

    public byte[] getCoef() {
        return this.coef;
    }

    public void setCoef(byte[] coef) {
        this.coef = coef;
    }

    public String toString() {
        return "SdfRSAPrivateKey{bits=" + this.bits + ", m=" + Arrays.toString(this.m) + ", e=" + Arrays.toString(this.e) + ", d=" + Arrays.toString(this.d) + ", prime=" + Arrays.toString((Object[])this.prime) + ", pexp=" + Arrays.toString((Object[])this.pexp) + ", coef=" + Arrays.toString(this.coef) + '}';
    }
}

