package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDK;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;

public enum SdfCryptoType {

    PCIE,
    YUNHSM;

    public SdfSDK getSdfSDK() throws SdfSDKException {
        switch (this) {
            case PCIE:
                return new PcieSdfSDK();
            case YUNHSM:
                return new YunhsmSdfSDK();
            default:
                throw new SdfSDKException("un known type");
        }
    }

    public static SdfSDK cloneSdfSDK(SdfSDK sdfSDK) throws SdfSDKException {
        if (sdfSDK instanceof YunhsmSdfSDK){
            return new YunhsmSdfSDK();
        } else if (sdfSDK instanceof PcieSdfSDK){
            return new PcieSdfSDK();
        } else {
            throw new SdfSDKException("un known type");
        }
    }
}
