package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;

public class SdfECKeyParameters extends AsymmetricKeyParameter {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private ECPublicKey publicKey;
    private SdfPrivateKey privateKey;

    /**
     * for
     * 1. sm2 engine encrypt
     * 2. sm2 signer verify
     *
     * @param publicKey public key
     */
    public SdfECKeyParameters(ECPublicKey publicKey) {
        super(false);
        this.publicKey = publicKey;
    }

    /**
     * for
     * 1. sm2 engine decrypt
     * 2. sm2 signer sign
     *
     * @param privateKey private key with sdf index and password
     */
    public SdfECKeyParameters(SdfPrivateKey privateKey) {
        super(true);
        this.privateKey = privateKey;
    }

    public ECPoint getQ() {
        return this.publicKey.getW();
    }

    public SdfECCPublicKey getSDFECCPublicKey() {
        if (this.publicKey != null) {
            return SdfECCPublicKey.getInstance(this.publicKey);
        } else {
            return null;
        }
    }

    public int getSm2Index() {
        return this.privateKey.getIndex();
    }

    public byte[] getPassword() {
        return this.privateKey.getPassword();
    }
}
