/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfContentOutputStream;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import java.io.OutputStream;
import java.security.SignatureException;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.RuntimeOperatorException;

public class SdfContentSigner
implements ContentSigner {
    private SdfContentOutputStream stream;

    public SdfContentSigner(SdfCryptoType sdfCryptoType, SdfPrivateKey privateKey) {
        this.stream = new SdfContentOutputStream(sdfCryptoType, true, new SdfECKeyParameters(privateKey));
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign_with_sm3);
    }

    public OutputStream getOutputStream() {
        return this.stream;
    }

    public byte[] getSignature() {
        try {
            return this.stream.getSignature();
        }
        catch (SignatureException e) {
            throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), (Throwable)e);
        }
    }
}

