/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfSM1Engine
implements BlockCipher {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int BLOCK_SIZE = 16;
    private SdfSDK sdfSDK;
    private long[] phKeyHandle;
    private boolean forEncryption;

    public SdfSM1Engine() throws SdfSDKException {
        this(SdfCryptoType.YUNHSM);
    }

    public SdfSM1Engine(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfSM1Engine(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to SM4 init - " + params.getClass().getName());
        }
        byte[] key = ((KeyParameter)params).getKey();
        if (key.length != 16) {
            throw new IllegalArgumentException("SM4 requires a 128 bit key");
        }
        try {
            this.phKeyHandle = this.sdfSDK.importKey(key);
            this.forEncryption = forEncryption;
        }
        catch (SdfSDKException e) {
            this.logger.error("init import key", (Throwable)e);
            throw new IllegalArgumentException("SDF SM4 init - import key error");
        }
    }

    public String getAlgorithmName() {
        return "SM1";
    }

    public int getBlockSize() {
        return 16;
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"processBlock in", (byte[])in);
        try {
            byte[] data = new byte[16];
            System.arraycopy(in, inOff, data, 0, 16);
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"processBlock data", (byte[])data);
            byte[] iv = new byte[16];
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"processBlock iv", (byte[])iv);
            if (this.forEncryption) {
                byte[] pucEncData = this.sdfSDK.encrypt(this.phKeyHandle, SdfAlgIdSymmetric.SGD_SM1_CBC, iv, data);
                System.arraycopy(pucEncData, 0, out, outOff, 16);
            } else {
                byte[] d = this.sdfSDK.decrypt(this.phKeyHandle, SdfAlgIdSymmetric.SGD_SM1_CBC, iv, data);
                System.arraycopy(d, 0, out, outOff, 16);
            }
        }
        catch (SdfSDKException e) {
            this.logger.error("processBlock", (Throwable)e);
            throw new DataLengthException(e.getMessage());
        }
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"processBlock out", (byte[])out);
        return 16;
    }

    public void reset() {
    }

    public void release() throws SdfSDKException {
        if (this.sdfSDK != null && this.phKeyHandle != null) {
            this.sdfSDK.destroyKey(this.phKeyHandle);
            this.sdfSDK.release();
        }
    }
}

