/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfSymmetricCipher {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int BLOCK_SIZE = 16;
    private SdfSDK sdfSDK;
    private long[] phKeyHandle;
    private byte[] key;
    private boolean forEncryption;
    private ParametersWithIV parametersWithIV;
    private SdfSymmetricKeyParameters sdfBlockCipherKeyParameters;

    public SdfSymmetricCipher() throws SdfSDKException {
        this(SdfCryptoType.YUNHSM);
    }

    public SdfSymmetricCipher(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfSymmetricCipher(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
    }

    public byte[] getKey() {
        return this.key;
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (params instanceof SdfSymmetricKeyParameters) {
            this.sdfBlockCipherKeyParameters = (SdfSymmetricKeyParameters)params;
            this.parametersWithIV = new ParametersWithIV(params, new byte[16]);
        } else if (params instanceof ParametersWithIV) {
            this.parametersWithIV = (ParametersWithIV)params;
            this.sdfBlockCipherKeyParameters = (SdfSymmetricKeyParameters)((ParametersWithIV)params).getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameter passed to SdfSymmetricCipher init - " + params.getClass().getName());
        }
        this.forEncryption = forEncryption;
        if (this.sdfBlockCipherKeyParameters.getKeyCipherType() == SdfSymmetricKeyParameters.KeyCipherType.NONE) {
            try {
                SdfSymmetricKey sdfSymmetricKey = new SdfSymmetricKey(this.sdfSDK);
                SdfSymmetricKey.KeyHandle keyHandle = sdfSymmetricKey.generateKeyWithEpkEccKeyHandle((ECPublicKey)this.sdfBlockCipherKeyParameters.getPublicKey());
                this.key = keyHandle.getCipherKey();
                this.phKeyHandle = keyHandle.getHandle();
            }
            catch (SdfSDKException e) {
                throw new IllegalArgumentException("SDF SM4 init - generate key error");
            }
            return;
        }
        this.key = this.sdfBlockCipherKeyParameters.getKey();
        try {
            switch (this.sdfBlockCipherKeyParameters.getKeyCipherType()) {
                case ECC_CIPHER: {
                    SdfSymmetricKey sdfSymmetricKey = new SdfSymmetricKey(this.sdfSDK);
                    this.phKeyHandle = sdfSymmetricKey.importKeyWithIskEcc(this.sdfBlockCipherKeyParameters.getSdfPrivateKey(), this.key);
                    break;
                }
                case PLAIN: {
                    if (this.key.length != 16) {
                        throw new IllegalArgumentException("SM4 requires a 128 bit key");
                    }
                    this.phKeyHandle = this.sdfSDK.importKey(this.key);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("SDF SM4 init - unknown key cipher type " + (Object)((Object)this.sdfBlockCipherKeyParameters.getKeyCipherType()));
                }
            }
        }
        catch (SdfSDKException e) {
            this.logger.error("init import key", (Throwable)e);
            throw new IllegalArgumentException("SDF SM4 init - import key error");
        }
    }

    public String getAlgorithmName() {
        return this.sdfBlockCipherKeyParameters.getSdfAlgIdBlockCipher().getName();
    }

    public int getBlockSize() {
        return 16;
    }

    public int getEncryptionLength(int inLength, SdfSymmetricKeyParameters.PaddingType paddingType) {
        if (paddingType == SdfSymmetricKeyParameters.PaddingType.NoPadding) {
            return inLength;
        }
        int paddingLength = 16 - inLength % 16;
        return inLength + paddingLength;
    }

    public byte[] doFinal(byte[] data) throws DataLengthException, IllegalStateException {
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"processBlock in", (byte[])data);
        this.logger.info("padding type " + (Object)((Object)this.sdfBlockCipherKeyParameters.getPaddingType()));
        try {
            byte[] plainText;
            byte[] iv = this.parametersWithIV.getIV();
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"processBlock iv", (byte[])iv);
            if (this.forEncryption) {
                byte[] plainText2;
                if (this.sdfBlockCipherKeyParameters.getPaddingType() == SdfSymmetricKeyParameters.PaddingType.NoPadding) {
                    plainText2 = new byte[data.length];
                    System.arraycopy(data, 0, plainText2, 0, data.length);
                } else {
                    int paddingLength = 16 - data.length % 16;
                    plainText2 = new byte[data.length + paddingLength];
                    System.arraycopy(data, 0, plainText2, 0, data.length);
                    byte padding = this.sdfBlockCipherKeyParameters.getPaddingType() == SdfSymmetricKeyParameters.PaddingType.SSL3Padding ? (byte)(paddingLength - 1) : (byte)paddingLength;
                    int off = data.length;
                    for (int i = 0; i < paddingLength; ++i) {
                        plainText2[off++] = padding;
                    }
                }
                byte[] pucEncData = this.sdfSDK.encrypt(this.phKeyHandle, this.sdfBlockCipherKeyParameters.getSdfAlgIdBlockCipher(), iv, plainText2);
                GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"processBlock pucEncData", (byte[])pucEncData);
                return pucEncData;
            }
            byte[] plain = this.sdfSDK.decrypt(this.phKeyHandle, this.sdfBlockCipherKeyParameters.getSdfAlgIdBlockCipher(), iv, data);
            byte lastByte = plain[plain.length - 1];
            switch (this.sdfBlockCipherKeyParameters.getPaddingType()) {
                case PKCS5Padding: 
                case PKCS7Padding: {
                    plainText = new byte[data.length - (lastByte & 0xFF)];
                    break;
                }
                case SSL3Padding: {
                    plainText = new byte[data.length - ((lastByte & 0xFF) + 1)];
                    break;
                }
                default: {
                    plainText = new byte[data.length];
                }
            }
            System.arraycopy(plain, 0, plainText, 0, plainText.length);
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"processBlock plainText", (byte[])plainText);
            return plainText;
        }
        catch (SdfSDKException e) {
            this.logger.error("processBlock", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void reset() {
    }

    public void release() throws SdfSDKException {
        if (this.sdfSDK != null && this.phKeyHandle != null) {
            this.sdfSDK.destroyKey(this.phKeyHandle);
            this.sdfSDK.release();
        }
    }
}

