/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfRandom
extends SecureRandom {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SdfSDK sdfSDK;

    public SdfRandom() throws SdfSDKException {
        this(SdfCryptoType.YUNHSM);
    }

    public SdfRandom(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfRandom(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
    }

    public byte[] generateRandom(int len) throws SdfSDKException {
        return this.sdfSDK.generateRandom(len);
    }

    @Override
    public void nextBytes(byte[] bytes) {
        try {
            byte[] out = this.sdfSDK.generateRandom(bytes.length);
            System.arraycopy(out, 0, bytes, 0, bytes.length);
        }
        catch (SdfSDKException e) {
            this.logger.error("sdfSDK generateRandom " + bytes.length, (Throwable)e);
        }
    }

    public void release() throws SdfSDKException {
        if (this.sdfSDK != null) {
            this.sdfSDK.release();
        }
    }
}

