/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.util.Memoable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfSM3Digest
implements ExtendedDigest,
Memoable {
    private Logger logger = LoggerFactory.getLogger((String)(this.getClass().getName() + "[" + this.getClass().hashCode() + "]"));
    private static final int DIGEST_LENGTH = 32;
    private static final int BYTE_LENGTH = 64;
    private SdfSDK sdfSDK;
    private byte[] pucID;
    private SdfECCPublicKey publicKey;
    private byte[] in = new byte[0];
    private volatile boolean isInit = false;

    public SdfSM3Digest() throws SdfSDKException {
        this(SdfCryptoType.YUNHSM);
    }

    public SdfSM3Digest(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfSM3Digest(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
    }

    public SdfSM3Digest(SdfSDK sdfSDK, byte[] pucID, SdfECCPublicKey publicKey) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
        this.pucID = pucID;
        this.publicKey = publicKey;
    }

    public SdfSM3Digest(SdfCryptoType sdfCryptoType, byte[] pucID, SdfECCPublicKey publicKey) throws SdfSDKException {
        this.reset();
        this.sdfSDK = sdfCryptoType.getSdfSDK();
        this.sdfSDK.init();
        this.pucID = pucID;
        this.publicKey = publicKey;
    }

    public SdfSM3Digest(SdfSM3Digest t) throws SdfSDKException {
        this.copyIn(t);
    }

    private void init() throws SdfSDKException {
        this.sdfSDK.hashInit(SdfAlgIdHash.SGD_SM3);
        this.isInit = true;
    }

    private void init(byte[] pucID, SdfECCPublicKey publicKey) throws SdfSDKException {
        this.pucID = pucID;
        this.publicKey = publicKey;
        this.sdfSDK.hashInit(SdfAlgIdHash.SGD_SM3, pucID, publicKey);
        this.isInit = true;
    }

    private void checkInit() throws SdfSDKException {
        if (!this.isInit) {
            if (this.publicKey != null && this.pucID != null) {
                this.init(this.pucID, this.publicKey);
            } else {
                this.init();
            }
        }
    }

    private void copyIn(SdfSM3Digest t) throws SdfSDKException {
        this.sdfSDK = SdfCryptoType.cloneSdfSDK(t.sdfSDK);
        this.sdfSDK.init();
        this.publicKey = t.publicKey;
        this.pucID = t.pucID;
        this.checkInit();
        if (t.in != null) {
            this.update(t.in, 0, t.in.length);
        }
    }

    public String getAlgorithmName() {
        return "SM3";
    }

    public int getDigestSize() {
        return 32;
    }

    public void update(byte in) {
        byte[] data = new byte[]{in};
        this.update(data, 0, data.length);
    }

    public void update(byte[] in, int inOff, int len) {
        byte[] data = new byte[len];
        System.arraycopy(in, inOff, data, 0, len);
        byte[] out = new byte[this.in.length + len];
        System.arraycopy(this.in, 0, out, 0, this.in.length);
        System.arraycopy(data, 0, out, this.in.length, len);
        this.in = out;
        try {
            this.checkInit();
            this.sdfSDK.hashUpdate(data);
        }
        catch (SdfSDKException e) {
            this.logger.error("update in.length {}", (Object)in.length, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doFinal(byte[] out, int outOff) {
        try {
            byte[] res = this.sdfSDK.hashFinal();
            System.arraycopy(res, 0, out, outOff, res.length);
        }
        catch (SdfSDKException e) {
            this.logger.error("doFinal", (Throwable)e);
        }
        finally {
            this.isInit = false;
        }
        return 32;
    }

    public void reset() {
    }

    public void releaseConnection() {
        if (this.sdfSDK instanceof YunhsmSdfSDK) {
            ((YunhsmSdfSDK)this.sdfSDK).releaseConnection();
        }
    }

    public int getByteLength() {
        return 64;
    }

    public void release() throws SdfSDKException {
        if (this.sdfSDK != null) {
            this.sdfSDK.release();
        }
    }

    public Memoable copy() {
        try {
            return new SdfSM3Digest(this);
        }
        catch (SdfSDKException e) {
            this.logger.error("Memoable copy", (Throwable)e);
            return null;
        }
    }

    public void reset(Memoable other) {
        SdfSM3Digest d = (SdfSM3Digest)other;
        try {
            this.copyIn(d);
        }
        catch (SdfSDKException e) {
            this.logger.error("reset copy in error", (Throwable)e);
        }
    }
}

