package com.xdja.pki.gmssl.crypto.sdf;

import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.RuntimeOperatorException;

import java.io.OutputStream;
import java.security.SignatureException;

public class SdfContentSigner implements ContentSigner {

    private SdfContentOutputStream stream;

    public SdfContentSigner(SdfCryptoType sdfCryptoType, SdfPrivateKey privateKey) {
        this.stream = new SdfContentOutputStream(sdfCryptoType, true, new SdfECKeyParameters(privateKey));
    }

    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign_with_sm3);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stream;
    }

    @Override
    public byte[] getSignature() {
        try {
            return stream.getSignature();
        } catch (SignatureException e) {
            throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
        }
    }
}
