package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.operator.RuntimeOperatorException;

import java.io.OutputStream;
import java.security.SignatureException;

public class SdfContentOutputStream extends OutputStream {
    private SdfSM2Signer sig;

    SdfContentOutputStream(SdfCryptoType sdfCryptoType, boolean forSigning, SdfECKeyParameters sdfECKeyParameters) {
        try {
            this.sig = new SdfSM2Signer(sdfCryptoType);
            this.sig.init(forSigning, sdfECKeyParameters);
        } catch (SdfSDKException e) {
            throw new RuntimeOperatorException("exception obtaining signature init : " + e.getMessage(), e);
        }
    }

    public void write(byte[] bytes, int off, int len) {
        sig.update(bytes, off, len);
    }

    public void write(byte[] bytes) {
        sig.update(bytes, 0, bytes.length);
    }

    @Override
    public void write(int b) {
        sig.update((byte) b);
    }

    byte[] getSignature() throws SignatureException {
        try {
            byte[] signature = sig.generateSignature();
            sig.release();
            return signature;
        } catch (CryptoException | SdfSDKException e) {
            throw new SignatureException("exception obtaining signature: " + e.getMessage(), e);
        }
    }

    boolean verify(byte[] expected) throws SignatureException {
        try {
            boolean verify = sig.verifySignature(expected);
            sig.release();
            return verify;
        } catch (SdfSDKException e) {
            throw new SignatureException("exception obtaining signature: " + e.getMessage(), e);
        }
    }
}