package com.xdja.pki.gmssl.crypto.sdf;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.bouncycastle.asn1.*;

import javax.security.auth.DestroyFailedException;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.Enumeration;

public class SdfPrivateKey implements PrivateKey {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private int sm2Index;
    private byte[] password;

    public static SdfPrivateKey getInstance(Object o) {
        if (o instanceof SdfPrivateKey) {
            return (SdfPrivateKey) o;
        } else if (o != null) {
            return new SdfPrivateKey(ASN1Sequence.getInstance(o));
        }

        return null;
    }

    public SdfPrivateKey(ASN1Sequence asn1Sequence) {
        Enumeration e = asn1Sequence.getObjects();
        sm2Index = ASN1Integer.getInstance(e.nextElement()).getValue().intValue();
        password = DEROctetString.getInstance(e.nextElement()).getOctets();
        logger.info("SdfPrivateKey sm2Index " + sm2Index + " password " + new String(password));
    }

    public SdfPrivateKey(int sm2Index, byte[] password) {
        this.sm2Index = sm2Index;
        this.password = password;
    }

    public int getSm2Index() {
        return sm2Index;
    }

    public void setSm2Index(int sm2Index) {
        this.sm2Index = sm2Index;
    }

    public byte[] getPassword() {
        return password;
    }

    public void setPassword(byte[] password) {
        this.password = password;
    }

    @Override
    public String getAlgorithm() {
        return "PCIE";
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        ASN1Integer sm2Index = new ASN1Integer(this.sm2Index);
        ASN1OctetString password = new DEROctetString(this.password);

        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(sm2Index);
        vector.add(password);

        ASN1Sequence sequence = new DERSequence(vector);
        try {
            return sequence.getEncoded();
        } catch (IOException e) {
            logger.error("sequence getEncoded", e);
        }
        return null;
    }

    @Override
    public void destroy() throws DestroyFailedException {

    }

    @Override
    public boolean isDestroyed() {
        return false;
    }

    @Override
    public String toString() {
        return "SdfPrivateKey{" +
                "sm2Index=" + sm2Index +
                ", password=" + new String(password) +
                '}';
    }
}
