package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfSM3Hmac {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final int DIGEST_LENGTH = 32;   // bytes
    private SdfSDK sdfSDK;

    public SdfSM3Hmac() throws SdfSDKException {
        this(SdfCryptoType.YUNHSUM);
    }

    public SdfSM3Hmac(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfSM3Hmac(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
    }

    public byte[] hmacHash(byte[] data, byte[] key) {
        try {
            return sdfSDK.sm3Hmac(data, key);
        } catch (SdfSDKException e) {
            logger.error("hmacHash", e);
        }
        return new byte[0];
    }

    public int getDigestSize() {
        return DIGEST_LENGTH;
    }

    public int getMacLength() {
        return DIGEST_LENGTH;
    }

    public void reset() {

    }


    public void release() throws SdfSDKException {
        if (sdfSDK != null) {
            sdfSDK.release();
        }
    }
}
