package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.asn1.crypto.ASN1SM2Cipher;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfECCCipher;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.security.interfaces.ECPublicKey;

public class SdfSymmetricKey {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private SdfSDK sdfSDK;

    public SdfSymmetricKey() throws SdfSDKException {
        this(SdfCryptoType.YUNHSUM);
    }

    public SdfSymmetricKey(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfSymmetricKey(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        sdfSDK.init();
    }

    public byte[] generateKeyWithEpkEcc(ECPublicKey publicKey) throws SdfSDKException {
        SdfECCPublicKey sdfECCPublicKey = SdfECCPublicKey.getInstance(publicKey);
        SdfECCCipher eccCipher = this.sdfSDK.generateKeyWithEpkEcc(sdfECCPublicKey);
        ASN1SM2Cipher asn1SM2Cipher = new ASN1SM2Cipher(eccCipher.getX(), eccCipher.getY(), eccCipher.getM(), eccCipher.getC());
        byte[] out;
        try {
            out = asn1SM2Cipher.toASN1Primitive().getEncoded();
        } catch (IOException e) {
            throw new SdfSDKException("asn1 sm2 cipher encode error", e);
        }
        GMSSLByteArrayUtils.printHexBinary(logger, "encrypt", out);
        return out;
    }

    public long[] generateKeyWithEpkEccHandle(ECPublicKey publicKey) throws SdfSDKException, IOException {
        SdfECCPublicKey sdfECCPublicKey = SdfECCPublicKey.getInstance(publicKey);
        return this.sdfSDK.generateKeyWithEpkEccHandle(sdfECCPublicKey);
    }

    public long[] importKeyWithIskEcc(SdfPrivateKey sdfPrivateKey, byte[] cipher) throws SdfSDKException {
        ASN1SM2Cipher sm2CipherASN1 = ASN1SM2Cipher.getInstance(cipher);
        assert sm2CipherASN1 != null;
        SdfECCCipher sdfECCCipher = new SdfECCCipher(
                sm2CipherASN1.getxCoordinate().toByteArray(),
                sm2CipherASN1.getyCoordinate().toByteArray(),
                sm2CipherASN1.getHash(),
                sm2CipherASN1.getCipherText().length,
                sm2CipherASN1.getCipherText()
        );
        //获取私钥访问权限
        sdfSDK.getPrivateKeyAccessRight(sdfPrivateKey.getSm2Index(), sdfPrivateKey.getPassword());
        //SM2解密
        long[] handle = sdfSDK.importKeyWithIskEcc(sdfPrivateKey.getSm2Index(), sdfECCCipher);
        //释放私钥访问权限
        sdfSDK.releasePrivateKeyAccessRight(sdfPrivateKey.getSm2Index());
        return handle;
    }

    public void destroyKey(long[] handle) throws SdfSDKException {
        this.sdfSDK.destroyKey(handle);
    }

    public void release() throws SdfSDKException {
        this.sdfSDK.release();
    }
}