package com.xdja.pki.gmssl.crypto.sdf.pcie.d;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DPCIEDemo {

    private static Logger logger = LoggerFactory.getLogger(DPCIEDemo.class.getName());

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0] == null) {
            System.out.println("Please insert method, Example: all. sm2sign. sm2enc. sm3hash");
            return;
        }
        System.out.println("You want to test: " + args[0]);

        switch (args[0]) {
            case "all":
                System.out.println("*************** all ***************");
                break;
            case "sm2sign":
                sm2SignDemo();
                break;
            case "sm2enc":
                sm2EncDemo();
                break;
            case "sm3hash":
                sm3HashDemo();
                break;
            default:
                System.out.println("不支持的命令！");
                break;
        }
    }

    /**
     * 导入SM2公私钥对 并进行 签名验签
     **/
    private static void sm2SignDemo() throws Exception {
        byte[] data = "12345678123456781234567812345678".getBytes();
        byte[] sign = DPCIESM2Signer.sign(data);
        GMSSLByteArrayUtils.printHexBinary(logger, "DPCIESM2Signer.sign", sign);
        boolean isSign = DPCIESM2Signer.verify(data, sign);
        System.out.println("DPCIESM2Signer.verify " + isSign);
    }

    /**
     * 导入SM2公私钥对 并进行 加密解密操作
     **/
    private static void sm2EncDemo() throws Exception {
        byte[] data = "12345678123456781234567812345678".getBytes();
        byte[] cipher = DPCIESM2Engine.encrypt(data);
        GMSSLByteArrayUtils.printHexBinary(logger, "DPCIESM2Engine.encrypt", cipher);
        byte[] d = DPCIESM2Engine.decrypt(cipher);
        GMSSLByteArrayUtils.printHexBinary(logger, "DPCIESM2Engine.decrypt", d);
    }

    public static void sm3HashDemo() throws SdfSDKException {
        byte[] data = "12345678123456781234567812345678".getBytes();
        byte[] out = DPCIESM3Digest.hash(data);
        GMSSLByteArrayUtils.printHexBinary(logger, "digest.doFinal", out);
    }
}
