package com.xdja.pki.gmssl.crypto.sdf.pcie.d;

import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2Engine;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDK;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDKUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.security.Security;
import java.security.interfaces.ECPublicKey;

public class DPCIESM2Engine {

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    public static byte[] encrypt(byte[] data) throws Exception {
        SdfSM2Engine psm2Engine = generateEngine(true);
        byte[] encrypt = psm2Engine.encryptASN1(data);
        psm2Engine.release();
        return encrypt;
    }

    public static byte[] decrypt(byte[] cipher) throws Exception {
        SdfSM2Engine psm2Engine = generateEngine(false);
        byte[] decrypt = psm2Engine.decryptASN1(cipher);
        psm2Engine.release();
        return decrypt;
    }

    private static SdfSM2Engine generateEngine(boolean forEncryption) throws Exception {
        byte[] pwd = "xdja1234".getBytes();
        int sm2Index = 1;
        ECPublicKey ecPublicKey = (ECPublicKey) PcieSdfSDKUtils.getPublicKeyFromCer("cert/admin14_enc.cer");
        SdfECKeyParameters key = new SdfECKeyParameters(new SdfPrivateKey(sm2Index, pwd));
        PcieSdfSDK sdfSDK = new PcieSdfSDK();
        SdfSM2Engine psm2Engine = new SdfSM2Engine(sdfSDK);
        psm2Engine.init(forEncryption, key);
        return psm2Engine;
    }
}
