package com.xdja.pki.gmssl.crypto.sdf.pcie.d;

import com.xdja.pki.gmssl.crypto.sdf.SdfSM3Digest;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.security.Security;

public class DPCIESM3Digest {

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    public static byte[] hash(byte[] data) throws SdfSDKException {
        SdfSM3Digest digest = new SdfSM3Digest();
        digest.update(data, 0, data.length);
        byte[] out = new byte[digest.getDigestSize()];
        digest.doFinal(out, 0);
        digest.release();
        return out;
    }
}
