/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2Signer;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.io.OutputStream;
import java.security.SignatureException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.operator.RuntimeOperatorException;

public class SdfContentOutputStream
extends OutputStream {
    private SdfSM2Signer sig;

    SdfContentOutputStream(SdfCryptoType sdfCryptoType, boolean forSigning, SdfECKeyParameters sdfECKeyParameters) {
        try {
            this.sig = new SdfSM2Signer(sdfCryptoType);
            this.sig.init(forSigning, (CipherParameters)sdfECKeyParameters);
        }
        catch (SdfSDKException e) {
            throw new RuntimeOperatorException("exception obtaining signature init : " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        this.sig.update(bytes, off, len);
    }

    @Override
    public void write(byte[] bytes) {
        this.sig.update(bytes, 0, bytes.length);
    }

    @Override
    public void write(int b) {
        this.sig.update((byte)b);
    }

    byte[] getSignature() throws SignatureException {
        try {
            byte[] signature = this.sig.generateSignature();
            this.sig.release();
            return signature;
        }
        catch (SdfSDKException | CryptoException e) {
            throw new SignatureException("exception obtaining signature: " + e.getMessage(), e);
        }
    }

    boolean verify(byte[] expected) throws SignatureException {
        try {
            boolean verify = this.sig.verifySignature(expected);
            this.sig.release();
            return verify;
        }
        catch (SdfSDKException e) {
            throw new SignatureException("exception obtaining signature: " + e.getMessage(), e);
        }
    }
}

