/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfContentOutputStream;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import java.io.OutputStream;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.RuntimeOperatorException;

public class SdfContentVerifier
implements ContentVerifier {
    private SdfContentOutputStream stream;

    public SdfContentVerifier(SdfCryptoType sdfCryptoType, ECPublicKey publicKey) {
        this.stream = new SdfContentOutputStream(sdfCryptoType, false, new SdfECKeyParameters(publicKey));
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign_with_sm3);
    }

    public OutputStream getOutputStream() {
        return this.stream;
    }

    public boolean verify(byte[] expected) {
        try {
            return this.stream.verify(expected);
        }
        catch (SignatureException e) {
            throw new RuntimeOperatorException("exception obtaining verify: " + e.getMessage(), (Throwable)e);
        }
    }
}

