/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import java.io.IOException;
import java.security.PrivateKey;
import java.util.Enumeration;
import javax.security.auth.DestroyFailedException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfPrivateKey
implements PrivateKey {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int sm2Index;
    private byte[] password;

    public static SdfPrivateKey getInstance(Object o) {
        if (o instanceof SdfPrivateKey) {
            return (SdfPrivateKey)o;
        }
        if (o != null) {
            return new SdfPrivateKey(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public SdfPrivateKey(ASN1Sequence asn1Sequence) {
        Enumeration e = asn1Sequence.getObjects();
        this.sm2Index = ASN1Integer.getInstance(e.nextElement()).getValue().intValue();
        this.password = DEROctetString.getInstance(e.nextElement()).getOctets();
        this.logger.info("SdfPrivateKey sm2Index " + this.sm2Index + " password " + new String(this.password));
    }

    public SdfPrivateKey(int sm2Index, byte[] password) {
        this.sm2Index = sm2Index;
        this.password = password;
    }

    public int getSm2Index() {
        return this.sm2Index;
    }

    public void setSm2Index(int sm2Index) {
        this.sm2Index = sm2Index;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public void setPassword(byte[] password) {
        this.password = password;
    }

    @Override
    public String getAlgorithm() {
        return "PCIE";
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        ASN1Integer sm2Index = new ASN1Integer((long)this.sm2Index);
        DEROctetString password = new DEROctetString(this.password);
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)sm2Index);
        vector.add((ASN1Encodable)password);
        DERSequence sequence = new DERSequence(vector);
        try {
            return sequence.getEncoded();
        }
        catch (IOException e) {
            this.logger.error("sequence getEncoded", (Throwable)e);
            return null;
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
    }

    @Override
    public boolean isDestroyed() {
        return false;
    }

    public String toString() {
        return "SdfPrivateKey{sm2Index=" + this.sm2Index + ", password=" + new String(this.password) + '}';
    }
}

