/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.asn1.crypto.ASN1SM2Cipher;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfECCCipher;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfSM2Engine {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SdfECKeyParameters ecKey;
    private boolean forEncryption;
    private SdfSDK sdfSDK;

    public SdfSM2Engine() throws SdfSDKException {
        this(SdfCryptoType.YUNHSUM);
    }

    public SdfSM2Engine(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfSM2Engine(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
    }

    public void init(boolean forEncryption, CipherParameters param) {
        this.forEncryption = forEncryption;
        this.ecKey = (SdfECKeyParameters)param;
    }

    public PublicKey exportPublicKey() throws Exception {
        SdfECCPublicKey sdfECCPublicKey = this.sdfSDK.exportEncPublicKeyEcc(this.ecKey.getSm2Index());
        return GMSSLX509Utils.convertSM2PublicKey((byte[])sdfECCPublicKey.getX(), (byte[])sdfECCPublicKey.getY());
    }

    public byte[] encryptASN1(byte[] data) {
        try {
            SdfECCPublicKey sdfECCPublicKey = this.ecKey.getSDFECCPublicKey();
            SdfECCCipher eccCipher = this.sdfSDK.externalEncryptECC(sdfECCPublicKey, data);
            ASN1SM2Cipher asn1SM2Cipher = new ASN1SM2Cipher(eccCipher.getX(), eccCipher.getY(), eccCipher.getM(), eccCipher.getC());
            byte[] out = asn1SM2Cipher.toASN1Primitive().getEncoded();
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"encrypt", (byte[])out);
            return out;
        }
        catch (SdfSDKException | IOException e) {
            this.logger.error("encrypt asn1", e);
            return new byte[0];
        }
    }

    public byte[] decryptASN1(byte[] cipher) {
        ASN1SM2Cipher sm2CipherASN1 = ASN1SM2Cipher.getInstance((Object)cipher);
        try {
            assert (sm2CipherASN1 != null);
            SdfECCCipher eccCipher = new SdfECCCipher(sm2CipherASN1.getxCoordinate().toByteArray(), sm2CipherASN1.getyCoordinate().toByteArray(), sm2CipherASN1.getHash(), sm2CipherASN1.getCipherText().length, sm2CipherASN1.getCipherText());
            this.sdfSDK.getPrivateKeyAccessRight(this.ecKey.getSm2Index(), this.ecKey.getPassword());
            byte[] out = this.sdfSDK.internalDecryptECC(this.ecKey.getSm2Index(), sm2CipherASN1.getCipherText().length, eccCipher);
            this.sdfSDK.releasePrivateKeyAccessRight(this.ecKey.getSm2Index());
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"encrypt", (byte[])out);
            return out;
        }
        catch (SdfSDKException e) {
            this.logger.error("decrypt asn1", (Throwable)e);
            return new byte[0];
        }
    }

    public byte[] processBlockASN1(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] data = new byte[inLen];
        System.arraycopy(in, inOff, data, 0, inLen);
        if (this.forEncryption) {
            return this.encryptASN1(data);
        }
        return this.decryptASN1(data);
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] data = new byte[inLen];
        System.arraycopy(in, inOff, data, 0, inLen);
        if (this.forEncryption) {
            return this.encrypt(data);
        }
        return this.decrypt(data);
    }

    public byte[] encrypt(byte[] data) {
        try {
            SdfECCPublicKey sdfECCPublicKey = this.ecKey.getSDFECCPublicKey();
            SdfECCCipher eccCipher = this.sdfSDK.externalEncryptECC(sdfECCPublicKey, data);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] x = eccCipher.getX();
            byte[] y = eccCipher.getY();
            byte[] PO = new byte[x.length + y.length + 1];
            PO[0] = 4;
            System.arraycopy(x, 0, PO, 1, x.length);
            System.arraycopy(y, 0, PO, x.length + 1, y.length);
            out.write(PO);
            out.write(eccCipher.getC());
            out.write(eccCipher.getM());
            byte[] cipher = out.toByteArray();
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"encrypt", (byte[])cipher);
            return cipher;
        }
        catch (SdfSDKException | IOException e) {
            this.logger.error("encrypt", e);
            return new byte[0];
        }
    }

    public byte[] decrypt(byte[] cipher) {
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"cipher", (byte[])cipher);
        int curveLength = 32;
        int hashLength = 32;
        byte[] c1 = new byte[curveLength * 2 + 1];
        System.arraycopy(cipher, 0, c1, 0, c1.length);
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"c1", (byte[])c1);
        byte[] x = new byte[curveLength];
        System.arraycopy(c1, 1, x, 0, x.length);
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"x", (byte[])x);
        byte[] y = new byte[curveLength];
        System.arraycopy(c1, x.length + 1, y, 0, y.length);
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"y", (byte[])y);
        byte[] c = new byte[cipher.length - hashLength - c1.length];
        System.arraycopy(cipher, c1.length, c, 0, c.length);
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"c", (byte[])c);
        byte[] m = new byte[hashLength];
        System.arraycopy(cipher, cipher.length - hashLength, m, 0, hashLength);
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"m", (byte[])m);
        SdfECCCipher eccCipher = new SdfECCCipher(x, y, m, c.length, c);
        try {
            this.sdfSDK.getPrivateKeyAccessRight(this.ecKey.getSm2Index(), this.ecKey.getPassword());
            byte[] out = this.sdfSDK.internalDecryptECC(this.ecKey.getSm2Index(), c.length, eccCipher);
            this.sdfSDK.releasePrivateKeyAccessRight(this.ecKey.getSm2Index());
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"encrypt", (byte[])out);
            return out;
        }
        catch (SdfSDKException e) {
            this.logger.error("decrypt", (Throwable)e);
            return new byte[0];
        }
    }

    public void release() throws SdfSDKException {
        if (this.sdfSDK != null) {
            this.sdfSDK.release();
        }
    }
}

