/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM3Digest;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfECCSignature;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfSM2Signer
implements Signer,
ECConstants {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SdfSDK sdfSDK;
    private SdfSM3Digest digest;
    private SdfECKeyParameters ecKey;

    public SdfSM2Signer() throws SdfSDKException {
        this(SdfCryptoType.YUNHSUM);
    }

    public SdfSM2Signer(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfSM2Signer(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
    }

    public void init(boolean forSigning, CipherParameters param) {
        this.ecKey = (SdfECKeyParameters)param;
        byte[] userID = Hex.decode((String)"31323334353637383132333435363738");
        try {
            SdfECCPublicKey sdfECCPublicKey = forSigning ? this.sdfSDK.exportSignPublicKeyEcc(this.ecKey.getSm2Index()) : this.ecKey.getSDFECCPublicKey();
            this.digest = new SdfSM3Digest(this.sdfSDK, userID, sdfECCPublicKey);
        }
        catch (SdfSDKException e) {
            this.logger.error("init", (Throwable)e);
        }
    }

    public void update(byte b) {
        byte[] bytes = new byte[]{b};
        this.update(bytes, 0, bytes.length);
    }

    public void update(byte[] in, int off, int len) {
        this.digest.update(in, off, len);
    }

    public byte[] generateSignature() throws CryptoException, DataLengthException {
        byte[] out = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(out, 0);
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"signature sm3 digest", (byte[])out);
        try {
            this.sdfSDK.getPrivateKeyAccessRight(this.ecKey.getSm2Index(), this.ecKey.getPassword());
            SdfECCSignature sdfECCSignature = this.sdfSDK.internalSignECC(this.ecKey.getSm2Index(), out);
            this.sdfSDK.releasePrivateKeyAccessRight(this.ecKey.getSm2Index());
            return this.derEncode(sdfECCSignature.getR(), sdfECCSignature.getS());
        }
        catch (SdfSDKException | IOException e) {
            this.logger.error("generateSignature", e);
            return new byte[0];
        }
    }

    public boolean verifySignature(byte[] signature) {
        try {
            byte[] out = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(out, 0);
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"signature sm3 digest", (byte[])out);
            BigInteger[] bigIntegers = this.derDecode(signature);
            byte[] r = GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])bigIntegers[0].toByteArray());
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"verifySignature R", (byte[])r);
            byte[] s = GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])bigIntegers[1].toByteArray());
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"verifySignature S", (byte[])s);
            SdfECCSignature sdfECCSignature = new SdfECCSignature(r, s);
            this.sdfSDK.externalVerifyECC(this.ecKey.getSDFECCPublicKey(), out, sdfECCSignature);
            return true;
        }
        catch (SdfSDKException | IOException e) {
            this.logger.error("verifySignature", e);
            return false;
        }
    }

    public void reset() {
    }

    protected BigInteger[] derDecode(byte[] encoding) throws IOException {
        BigInteger s;
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)ASN1Primitive.fromByteArray((byte[])encoding));
        if (seq.size() != 2) {
            return null;
        }
        BigInteger r = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue();
        byte[] expectedEncoding = this.derEncode(r, s = ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue());
        if (!Arrays.constantTimeAreEqual((byte[])expectedEncoding, (byte[])encoding)) {
            return null;
        }
        return new BigInteger[]{r, s};
    }

    protected byte[] derEncode(byte[] r, byte[] s) throws IOException {
        return this.derEncode(BigIntegers.fromUnsignedByteArray((byte[])r), BigIntegers.fromUnsignedByteArray((byte[])s));
    }

    protected byte[] derEncode(BigInteger r, BigInteger s) throws IOException {
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"r", (byte[])r.toByteArray());
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"s", (byte[])s.toByteArray());
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        return new DERSequence(v).getEncoded("DER");
    }

    public void release() throws SdfSDKException {
        if (this.sdfSDK != null) {
            this.sdfSDK.release();
        }
    }
}

