/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfSM3Hmac {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int DIGEST_LENGTH = 32;
    private SdfSDK sdfSDK;

    public SdfSM3Hmac() throws SdfSDKException {
        this(SdfCryptoType.YUNHSUM);
    }

    public SdfSM3Hmac(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfSM3Hmac(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
    }

    public byte[] hmacHash(byte[] data, byte[] key) {
        try {
            return this.sdfSDK.sm3Hmac(data, key);
        }
        catch (SdfSDKException e) {
            this.logger.error("hmacHash", (Throwable)e);
            return new byte[0];
        }
    }

    public int getDigestSize() {
        return 32;
    }

    public int getMacLength() {
        return 32;
    }

    public void reset() {
    }

    public void release() throws SdfSDKException {
        if (this.sdfSDK != null) {
            this.sdfSDK.release();
        }
    }
}

