/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import org.bouncycastle.crypto.CipherParameters;

public class SdfSymmetricKeyParameters
implements CipherParameters {
    private byte[] key;
    private KeyCipherType keyCipherType;
    private final PaddingType paddingType;
    private SdfAlgIdSymmetric sdfAlgIdBlockCipher;
    private SdfPrivateKey sdfPrivateKey;

    public SdfSymmetricKeyParameters(PaddingType paddingType, SdfAlgIdSymmetric sdfAlgIdSymmetric, SdfPrivateKey sdfPrivateKey, byte[] cipherKey) {
        this(KeyCipherType.ECC, paddingType, sdfAlgIdSymmetric, sdfPrivateKey, cipherKey, 0, cipherKey.length);
    }

    public SdfSymmetricKeyParameters(PaddingType paddingType, SdfAlgIdSymmetric sdfAlgIdSymmetric, byte[] key) {
        this(KeyCipherType.None, paddingType, sdfAlgIdSymmetric, null, key, 0, key.length);
    }

    public SdfSymmetricKeyParameters(KeyCipherType keyCipherType, PaddingType paddingType, SdfAlgIdSymmetric sdfAlgIdSymmetric, SdfPrivateKey sdfPrivateKey, byte[] key, int keyOff, int keyLen) {
        if (keyCipherType == KeyCipherType.ECC && sdfPrivateKey == null) {
            throw new IllegalArgumentException("key cipher type is ecc, private key is not null");
        }
        this.keyCipherType = keyCipherType;
        this.paddingType = paddingType;
        this.sdfAlgIdBlockCipher = sdfAlgIdSymmetric;
        this.sdfPrivateKey = sdfPrivateKey;
        this.key = new byte[keyLen];
        System.arraycopy(key, keyOff, this.key, 0, keyLen);
    }

    public byte[] getKey() {
        return this.key;
    }

    public KeyCipherType getKeyCipherType() {
        return this.keyCipherType;
    }

    public PaddingType getPaddingType() {
        return this.paddingType;
    }

    public SdfAlgIdSymmetric getSdfAlgIdBlockCipher() {
        return this.sdfAlgIdBlockCipher;
    }

    public SdfPrivateKey getSdfPrivateKey() {
        return this.sdfPrivateKey;
    }

    public static enum PaddingType {
        NoPadding,
        PKCS5Padding,
        PKCS7Padding,
        SSL3Padding;

    }

    public static enum KeyCipherType {
        None,
        ECC;

    }
}

