/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf.pcie.d;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.pcie.d.DPCIESM2Engine;
import com.xdja.pki.gmssl.crypto.sdf.pcie.d.DPCIESM2Signer;
import com.xdja.pki.gmssl.crypto.sdf.pcie.d.DPCIESM3Digest;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DPCIEDemo {
    private static Logger logger = LoggerFactory.getLogger((String)DPCIEDemo.class.getName());

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0] == null) {
            System.out.println("Please insert method, Example: all. sm2sign. sm2enc. sm3hash");
            return;
        }
        System.out.println("You want to test: " + args[0]);
        switch (args[0]) {
            case "all": {
                System.out.println("*************** all ***************");
                break;
            }
            case "sm2sign": {
                DPCIEDemo.sm2SignDemo();
                break;
            }
            case "sm2enc": {
                DPCIEDemo.sm2EncDemo();
                break;
            }
            case "sm3hash": {
                DPCIEDemo.sm3HashDemo();
                break;
            }
            default: {
                System.out.println("\u4e0d\u652f\u6301\u7684\u547d\u4ee4\uff01");
            }
        }
    }

    private static void sm2SignDemo() throws Exception {
        byte[] data = "12345678123456781234567812345678".getBytes();
        byte[] sign = DPCIESM2Signer.sign(data);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"DPCIESM2Signer.sign", (byte[])sign);
        boolean isSign = DPCIESM2Signer.verify(data, sign);
        System.out.println("DPCIESM2Signer.verify " + isSign);
    }

    private static void sm2EncDemo() throws Exception {
        byte[] data = "12345678123456781234567812345678".getBytes();
        byte[] cipher = DPCIESM2Engine.encrypt(data);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"DPCIESM2Engine.encrypt", (byte[])cipher);
        byte[] d = DPCIESM2Engine.decrypt(cipher);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"DPCIESM2Engine.decrypt", (byte[])d);
    }

    public static void sm3HashDemo() throws SdfSDKException {
        byte[] data = "12345678123456781234567812345678".getBytes();
        byte[] out = DPCIESM3Digest.hash(data);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"digest.doFinal", (byte[])out);
    }
}

