/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf.pcie.d;

import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2Signer;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDK;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDKUtils;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DPCIESM2Signer {
    public static byte[] sign(byte[] data) throws Exception {
        SdfSM2Signer psm2Signer = DPCIESM2Signer.generateSigner(true);
        psm2Signer.update(data, 0, data.length);
        byte[] sign = psm2Signer.generateSignature();
        psm2Signer.release();
        return sign;
    }

    public static boolean verify(byte[] data, byte[] sign) throws Exception {
        SdfSM2Signer psm2Verifier = DPCIESM2Signer.generateSigner(false);
        psm2Verifier.update(data, 0, data.length);
        boolean isSign = psm2Verifier.verifySignature(sign);
        psm2Verifier.release();
        return isSign;
    }

    private static SdfSM2Signer generateSigner(boolean forSigning) throws Exception {
        byte[] pwd = "xdja1234".getBytes();
        int sm2Index = 1;
        ECPublicKey ecPublicKey = (ECPublicKey)PcieSdfSDKUtils.getPublicKeyFromCer((String)"cert/admin14_sign.cer");
        SdfECKeyParameters key = new SdfECKeyParameters(new SdfPrivateKey(sm2Index, pwd));
        PcieSdfSDK sdfSDK = new PcieSdfSDK();
        SdfSM2Signer psm2Signer = new SdfSM2Signer((SdfSDK)sdfSDK);
        psm2Signer.init(forSigning, (CipherParameters)key);
        return psm2Signer;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

