/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf.pcie.demo;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfRandom;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2Engine;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2Signer;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM3Digest;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM4Engine;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDK;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCryptoDemo {
    private static Logger logger = LoggerFactory.getLogger((String)PCryptoDemo.class.getName());

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0] == null) {
            System.out.println("Please insert method, Example: all. random. sm2sign. sm2enc. sm4enc. sm3hash. sm3hmac. sm4mac");
            return;
        }
        System.out.println("You want to test: " + args[0]);
        PcieSdfSDK sdfSDK = new PcieSdfSDK();
        switch (args[0]) {
            case "all": {
                System.out.println("*************** sm2SignDemo ***************");
                PCryptoDemo.sm2SignDemo(sdfSDK);
                System.out.println("*************** sm2EncDemo ***************");
                PCryptoDemo.sm2EncDemo(sdfSDK);
                System.out.println("*************** sm4EncDemo ***************");
                PCryptoDemo.sm4EncDemo(sdfSDK);
                System.out.println("*************** sm3HashDemo ***************");
                PCryptoDemo.sm3HashDemo(sdfSDK);
                System.out.println("*************** sm3HmacDemo ***************");
                PCryptoDemo.sm3HmacDemo(sdfSDK);
                System.out.println("*************** sm4MacDemo ***************");
                PCryptoDemo.sm4MacDemo(sdfSDK);
                break;
            }
            case "random": {
                PCryptoDemo.random(sdfSDK);
                break;
            }
            case "sm2sign": {
                PCryptoDemo.sm2SignDemo(sdfSDK);
                break;
            }
            case "sm2enc": {
                PCryptoDemo.sm2EncDemo(sdfSDK);
                break;
            }
            case "sm4enc": {
                PCryptoDemo.sm4EncDemo(sdfSDK);
                break;
            }
            case "sm3hash": {
                PCryptoDemo.sm3HashDemo(sdfSDK);
                break;
            }
            case "sm3hmac": {
                PCryptoDemo.sm3HmacDemo(sdfSDK);
                break;
            }
            case "sm4mac": {
                PCryptoDemo.sm4MacDemo(sdfSDK);
                break;
            }
            default: {
                System.out.println("\u4e0d\u652f\u6301\u7684\u547d\u4ee4\uff01");
            }
        }
    }

    private static void random(PcieSdfSDK sdfSDK) throws Exception {
        SdfRandom pRandom = new SdfRandom((SdfSDK)sdfSDK);
        byte[] out = pRandom.generateRandom(28);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"random 28 ", (byte[])out);
        byte[] bs = new byte[32];
        pRandom.nextBytes(bs);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"random 32 ", (byte[])bs);
    }

    private static void sm2SignDemo(PcieSdfSDK sdfSDK) throws Exception {
        char[] pw = "63fbd873".toCharArray();
        String signP12 = "cert/admin14_sign_63fbd873.p12";
        byte[] pwd = "xdja1234".getBytes();
        int sm2Index = 1;
        byte[] data = "12345678123456781234567812345678".getBytes();
        Object ecPublicKey = null;
        SdfECKeyParameters key = new SdfECKeyParameters(new SdfPrivateKey(sm2Index, pwd));
        SdfSM2Signer psm2Signer = new SdfSM2Signer((SdfSDK)sdfSDK);
        psm2Signer.init(true, (CipherParameters)key);
        psm2Signer.update(data, 0, data.length);
        byte[] sign = psm2Signer.generateSignature();
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"psm2Signer.generateSignature()", (byte[])sign);
        SdfSM2Signer psm2Verifier = new SdfSM2Signer((SdfSDK)sdfSDK);
        psm2Verifier.init(false, (CipherParameters)key);
        psm2Verifier.update(data, 0, data.length);
        boolean isSign = psm2Verifier.verifySignature(sign);
        System.out.println("sm2 is sign verify " + isSign);
    }

    private static void sm2EncDemo(PcieSdfSDK sdfSDK) throws Exception {
        char[] pw = "63fbd873".toCharArray();
        String encP12 = "cert/admin14_enc_63fbd873.p12";
        byte[] pwd = "xdja1234".getBytes();
        int sm2Index = 1;
        byte[] data = "1234567812345678123456781234567811".getBytes();
        System.out.println();
        System.out.println("start sm2 encrypt asn.1");
        System.out.println();
        ECPublicKey ecPublicKey = null;
        SdfSM2Engine encryptEngine = new SdfSM2Engine((SdfSDK)sdfSDK);
        SdfECKeyParameters encrytKey = new SdfECKeyParameters(ecPublicKey);
        encryptEngine.init(true, (CipherParameters)encrytKey);
        byte[] cipherASN1 = encryptEngine.encryptASN1(data);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"encryptEngine.encryptASN1", (byte[])cipherASN1);
        System.out.println();
        System.out.println("start sm2 encrypt asn.1");
        System.out.println();
        SdfSM2Engine decryptEngine = new SdfSM2Engine((SdfSDK)sdfSDK);
        SdfECKeyParameters decryptKey = new SdfECKeyParameters(new SdfPrivateKey(sm2Index, pwd));
        decryptEngine.init(false, (CipherParameters)decryptKey);
        byte[] dASN1 = decryptEngine.decryptASN1(cipherASN1);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"decryptEngine.decryptASN1", (byte[])dASN1);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"data", (byte[])data);
        System.out.println();
        System.out.println("start sm2 encrypt not asn.1");
        System.out.println();
        byte[] cipher = encryptEngine.encrypt(data);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"encryptEngine.encrypt", (byte[])cipher);
        System.out.println();
        System.out.println("start sm2 decrypt not asn.1");
        System.out.println();
        byte[] d = decryptEngine.decrypt(cipher);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"decryptEngine.decrypt", (byte[])d);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"data", (byte[])data);
    }

    public static void sm4EncDemo(PcieSdfSDK sdfSDK) throws SdfSDKException {
        byte[] key = "1234567812345678".getBytes();
        byte[] data = "12345678123456781234567812345678".getBytes();
        System.out.println(data.length);
        KeyParameter keyParameter = new KeyParameter(key, 0, 16);
        SdfSM4Engine encrypt = new SdfSM4Engine();
        encrypt.init(true, (CipherParameters)keyParameter);
        byte[] eOut = new byte[data.length];
        encrypt.processBlock(data, 0, eOut, 0);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"encrypt.processBlock", (byte[])eOut);
        encrypt.reset();
        SdfSM4Engine decrypt = new SdfSM4Engine();
        decrypt.init(false, (CipherParameters)keyParameter);
        byte[] dOut = new byte[data.length];
        decrypt.processBlock(data, 0, dOut, 0);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"decrypt.processBlock", (byte[])dOut);
        decrypt.reset();
    }

    public static void sm3HashDemo(PcieSdfSDK sdfSDK) throws SdfSDKException {
        byte[] data = "12345678123456781234567812345678".getBytes();
        SdfSM3Digest digest = new SdfSM3Digest();
        digest.update(data, 0, data.length);
        byte[] out = new byte[digest.getDigestSize()];
        digest.doFinal(out, 0);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"digest.doFinal", (byte[])out);
    }

    public static void sm3HmacDemo(PcieSdfSDK sdfSDK) throws SdfSDKException {
        byte[] data = "12345678123456781234567812345678".getBytes();
        byte[] key = "12345678123456781234567812345678".getBytes();
        byte[] mac = sdfSDK.sm3Hmac(data, key);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"sdfSDK.sm3Hmac", (byte[])mac);
    }

    public static void sm4MacDemo(PcieSdfSDK sdfSDK) throws SdfSDKException {
        sdfSDK.calculateMac(1);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

