/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfRSAKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfSHADigest;
import com.xdja.pki.gmssl.crypto.sdf.SdfSHAType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSigner;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfRSASigner
extends SdfSigner {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SdfSHAType sdfSHAType;
    private SdfSHADigest sdfSHADigest;
    private SdfRSAKeyParameters keyParameters;
    private byte[] userId;

    public SdfRSASigner(SdfCryptoType sdfCryptoType, ASN1ObjectIdentifier aid) throws SdfSDKException {
        this(sdfCryptoType, SdfSHAType.convertSdfSHAType(aid));
    }

    public SdfRSASigner(SdfCryptoType sdfCryptoType, String algorithm) throws SdfSDKException {
        this(sdfCryptoType, SdfSHAType.convertSdfSHAType(algorithm));
    }

    public SdfRSASigner(SdfSHAType sdfSHAType) throws SdfSDKException {
        this(SdfCryptoType.YUNHSM, sdfSHAType);
    }

    public SdfRSASigner(SdfCryptoType sdfCryptoType, SdfSHAType sdfSHAType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK(), sdfSHAType);
    }

    public SdfRSASigner(SdfSDK sdfSDK, SdfSHAType sdfSHAType) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
        this.sdfSHAType = sdfSHAType;
        if (sdfSHAType == SdfSHAType.SHA1_WITH_RSA) {
            this.sdfSHADigest = new SdfSHADigest(sdfSDK, SdfAlgIdHash.SGD_SHA1);
        } else if (sdfSHAType == SdfSHAType.SHA256_WITH_RSA) {
            this.sdfSHADigest = new SdfSHADigest(sdfSDK, SdfAlgIdHash.SGD_SHA256);
        } else {
            throw new SdfSDKException("\u6682\u4e0d\u652f\u6301" + sdfSHAType.getSigAlgName() + "\u7c7b\u578b");
        }
        if ("SGD_SHA256".equalsIgnoreCase(this.sdfSHADigest.getAlgorithmName())) {
            this.userId = Hex.decode((String)"3031300d060960864801650304020105000420");
        } else if ("SGD_SHA1".equalsIgnoreCase(this.sdfSHADigest.getAlgorithmName())) {
            this.userId = Hex.decode((String)"3021300906052b0e03021a05000414");
        } else {
            throw new SdfSDKException("\u6682\u4e0d\u652f\u6301" + this.sdfSHADigest.getAlgorithmName() + "\u7c7b\u578b");
        }
    }

    public void init(boolean forSigning, CipherParameters param) {
        this.keyParameters = (SdfRSAKeyParameters)param;
    }

    public void update(byte b) {
        byte[] bytes = new byte[]{b};
        this.update(bytes, 0, bytes.length);
    }

    public void update(byte[] in, int off, int len) {
        this.sdfSHADigest.update(in, off, len);
    }

    public byte[] generateSignature() throws DataLengthException {
        try {
            byte[] out = new byte[this.sdfSHADigest.getDigestSize()];
            this.sdfSHADigest.doFinal(out, 0);
            byte[] data = GMSSLByteArrayUtils.buildByteArryay((byte[])this.userId, (byte[])out);
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)" sha hash ", (byte[])data);
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)("signature " + this.sdfSHAType.getSigAlgName() + " digest"), (byte[])data);
            byte[] sign = this.sdfSDK.internalPrivateKeyOperationRsa(this.keyParameters.getPrivateKeyIndex(), this.keyParameters.getPassword(), data);
            return sign;
        }
        catch (Exception e) {
            this.logger.error("generateSignature", (Throwable)e);
            return new byte[0];
        }
    }

    public boolean verifySignature(byte[] signature) {
        try {
            byte[] out = new byte[this.sdfSHADigest.getDigestSize()];
            this.sdfSHADigest.doFinal(out, 0);
            byte[] normal = GMSSLByteArrayUtils.buildByteArryay((byte[])this.userId, (byte[])out);
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)" sha hash ", (byte[])out);
            RSAPublicKey rsaPublicKey = this.keyParameters.getPublicKey();
            SdfRSAPublicKey sdfRSAPublicKey = SdfRSAPublicKey.getInstance((RSAPublicKey)rsaPublicKey);
            this.logger.info("sdfrsaPublicKey.getBits() {}", (Object)sdfRSAPublicKey.getBits());
            byte[] verify = this.sdfSDK.externalPublicKeyOperationRsa(sdfRSAPublicKey, signature);
            byte[] data = new byte[normal.length];
            System.arraycopy(verify, verify.length - normal.length, data, 0, data.length);
            return GMSSLByteArrayUtils.isEqual((byte[])normal, (byte[])data);
        }
        catch (Exception e) {
            if (signature != null) {
                GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"verifySignature signature", (byte[])signature);
            }
            this.logger.error("verifySignature", (Throwable)e);
            return false;
        }
    }

    public void reset() {
    }
}

