/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.util.Memoable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfSHADigest
implements ExtendedDigest,
Memoable {
    private Logger logger = LoggerFactory.getLogger((String)(this.getClass().getName() + "[" + this.getClass().hashCode() + "]"));
    private static final int SHA1_DIGEST_LENGTH = 20;
    private static final int SHA256_DIGEST_LENGTH = 32;
    private static final int BYTE_LENGTH = 64;
    private SdfSDK sdfSDK;
    private SdfAlgIdHash sdfAlgIdHash;
    private byte[] in = new byte[0];
    private volatile boolean isInit = false;

    public SdfSHADigest(SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this(SdfCryptoType.YUNHSM, sdfAlgIdHash);
    }

    public SdfSHADigest(SdfCryptoType sdfCryptoType, SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK(), sdfAlgIdHash);
    }

    public SdfSHADigest(SdfSDK sdfSDK, SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
        this.sdfAlgIdHash = sdfAlgIdHash;
    }

    public SdfSHADigest(SdfSHADigest t) throws SdfSDKException {
        this.copyIn(t);
    }

    private void init() throws SdfSDKException {
        this.sdfSDK.hashInit(this.sdfAlgIdHash);
        this.isInit = true;
    }

    private void checkInit() throws SdfSDKException {
        if (!this.isInit) {
            this.init();
        }
    }

    private void copyIn(SdfSHADigest t) throws SdfSDKException {
        this.sdfSDK = SdfCryptoType.cloneSdfSDK(t.sdfSDK);
        this.sdfSDK.init();
        this.checkInit();
        if (t.in != null) {
            this.update(t.in, 0, t.in.length);
        }
    }

    public String getAlgorithmName() {
        return this.sdfAlgIdHash.getName();
    }

    public int getDigestSize() {
        return this.sdfAlgIdHash.getId() == SdfAlgIdHash.SGD_SHA1.getId() ? 20 : 32;
    }

    public void update(byte in) {
        byte[] data = new byte[]{in};
        this.update(data, 0, data.length);
    }

    public void update(byte[] in, int inOff, int len) {
        block3: {
            byte[] data = new byte[len];
            System.arraycopy(in, inOff, data, 0, len);
            byte[] out = new byte[this.in.length + len];
            System.arraycopy(this.in, 0, out, 0, this.in.length);
            System.arraycopy(data, 0, out, this.in.length, len);
            this.in = out;
            try {
                this.checkInit();
                while (len > 4096) {
                    byte[] m = new byte[4096];
                    System.arraycopy(data, 0, m, 0, m.length);
                    this.sdfSDK.hashUpdate(m);
                    len -= 4096;
                    byte[] dataNow = new byte[data.length - m.length];
                    System.arraycopy(data, m.length, dataNow, 0, data.length - m.length);
                    data = dataNow;
                }
                this.sdfSDK.hashUpdate(data);
            }
            catch (SdfSDKException e) {
                if (in.length == 0) break block3;
                this.logger.error("update in.length {}", (Object)in.length, (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doFinal(byte[] out, int outOff) {
        int length = this.sdfAlgIdHash.getId() == SdfAlgIdHash.SGD_SHA1.getId() ? 20 : 32;
        try {
            byte[] res = this.sdfSDK.hashFinal();
            System.arraycopy(res, 0, out, outOff, length);
        }
        catch (SdfSDKException e) {
            this.logger.error("doFinal", (Throwable)e);
        }
        finally {
            this.isInit = false;
        }
        return length;
    }

    public void reset() {
    }

    public void releaseConnection() {
        if (this.sdfSDK instanceof YunhsmSdfSDK) {
            ((YunhsmSdfSDK)this.sdfSDK).releaseConnection();
        }
    }

    public int getByteLength() {
        return 64;
    }

    public void release() throws SdfSDKException {
        if (this.sdfSDK != null) {
            this.sdfSDK.release();
        }
    }

    public Memoable copy() {
        try {
            return new SdfSHADigest(this);
        }
        catch (SdfSDKException e) {
            this.logger.error("Memoable copy", (Throwable)e);
            return null;
        }
    }

    public void reset(Memoable other) {
        SdfSHADigest d = (SdfSHADigest)other;
        try {
            this.copyIn(d);
        }
        catch (SdfSDKException e) {
            this.logger.error("reset copy in error", (Throwable)e);
        }
    }
}

