/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public enum SdfSHAType {
    SHA1_WITH_RSA(PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1WITHRSA"),
    SHA256_WITH_RSA(PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256WITHRSA");

    private ASN1ObjectIdentifier aid;
    private String sigAlgName;

    private SdfSHAType(ASN1ObjectIdentifier aid, String sigAlgName) {
        this.aid = aid;
        this.sigAlgName = sigAlgName;
    }

    public ASN1ObjectIdentifier getAid() {
        return this.aid;
    }

    public String getSigAlgName() {
        return this.sigAlgName;
    }

    public static SdfSHAType convertSdfSHAType(ASN1ObjectIdentifier aid) {
        if (PKCSObjectIdentifiers.sha1WithRSAEncryption.getId().equals(aid.getId())) {
            return SHA1_WITH_RSA;
        }
        if (PKCSObjectIdentifiers.sha256WithRSAEncryption.getId().equals(aid.getId())) {
            return SHA256_WITH_RSA;
        }
        return null;
    }

    public static SdfSHAType convertSdfSHAType(String algorithm) {
        if (SdfSHAType.SHA1_WITH_RSA.sigAlgName.equals(algorithm)) {
            return SHA1_WITH_RSA;
        }
        if (SdfSHAType.SHA256_WITH_RSA.sigAlgName.equals(algorithm)) {
            return SHA256_WITH_RSA;
        }
        return null;
    }

    public static boolean checkSupportType(ASN1ObjectIdentifier aid) {
        return SHA1_WITH_RSA.getAid().getId().equals(aid.getId()) || SHA256_WITH_RSA.getAid().getId().equals(aid.getId());
    }
}

